/*
 * Decompiled with CFR 0.152.
 */
package io.castled.schema.models;

import com.google.common.collect.Lists;
import io.castled.schema.models.Schema;
import io.castled.schema.models.SchemaType;
import java.math.BigDecimal;

public class DecimalSchema
extends Schema {
    private int scale;
    private int precision;

    public DecimalSchema(int scale, int precision, boolean optional) {
        super(SchemaType.DECIMAL, Lists.newArrayList((Object[])new Class[]{BigDecimal.class}), optional);
        this.scale = scale;
        this.precision = precision;
    }

    public static DecimalSchemaBuilder builder() {
        return new DecimalSchemaBuilder();
    }

    public int getScale() {
        return this.scale;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public static class DecimalSchemaBuilder {
        private int scale;
        private int precision;
        private boolean optional;

        DecimalSchemaBuilder() {
        }

        public DecimalSchemaBuilder scale(int scale) {
            this.scale = scale;
            return this;
        }

        public DecimalSchemaBuilder precision(int precision) {
            this.precision = precision;
            return this;
        }

        public DecimalSchemaBuilder optional(boolean optional) {
            this.optional = optional;
            return this;
        }

        public DecimalSchema build() {
            return new DecimalSchema(this.scale, this.precision, this.optional);
        }

        public String toString() {
            return "DecimalSchema.DecimalSchemaBuilder(scale=" + this.scale + ", precision=" + this.precision + ", optional=" + this.optional + ")";
        }
    }
}

