/*
 * Decompiled with CFR 0.152.
 */
package io.castled.schema;

import com.google.inject.Singleton;
import io.castled.exceptions.CastledRuntimeException;
import io.castled.schema.SchemaConstants;
import io.castled.schema.models.DecimalSchema;
import io.castled.schema.models.FieldSchema;
import io.castled.schema.models.RecordSchema;
import io.castled.schema.models.Schema;
import io.castled.schema.models.StringSchema;
import io.castled.schema.models.Tuple;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ResultSetSchemaMapper {
    private static final Logger log = LoggerFactory.getLogger(ResultSetSchemaMapper.class);

    public RecordSchema getSchema(ResultSetMetaData resultSetMetaData) throws SQLException {
        RecordSchema.Builder schemaBuilder = RecordSchema.builder();
        for (int column = 1; column <= resultSetMetaData.getColumnCount(); ++column) {
            int precision;
            int scale;
            String typeName;
            String columnLabel = resultSetMetaData.getColumnLabel(column);
            int columnType = resultSetMetaData.getColumnType(column);
            Schema columnSchema = this.getColumnSchema(columnType, typeName = resultSetMetaData.getColumnTypeName(column), scale = resultSetMetaData.getScale(column), precision = resultSetMetaData.getPrecision(column));
            if (columnSchema == null) continue;
            columnSchema.setOptional(true);
            schemaBuilder.put(columnLabel, columnSchema);
        }
        return schemaBuilder.build();
    }

    public Tuple getRecord(ResultSet resultSet, RecordSchema recordSchema) {
        Tuple.Builder recordBuilder = Tuple.builder();
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            for (int column = 1; column <= resultSetMetaData.getColumnCount(); ++column) {
                Object columnValue;
                String columnLabel = resultSetMetaData.getColumnLabel(column);
                int columnType = resultSetMetaData.getColumnType(column);
                String typeName = resultSetMetaData.getColumnTypeName(column);
                Schema columnSchema = recordSchema.getSchema(columnLabel);
                if (columnSchema == null || (columnValue = this.getColumnValue(resultSet.getObject(columnLabel), columnSchema, columnType, typeName)) == null) continue;
                recordBuilder.put(new FieldSchema(columnLabel, columnSchema), columnValue);
            }
        }
        catch (SQLException e) {
            log.error("Failed to read record from result set", (Throwable)e);
            throw new CastledRuntimeException(e.getMessage());
        }
        return recordBuilder.build();
    }

    public Object getColumnValue(Object value, Schema columnSchema, int columnType, String typeName) {
        if (value == null) {
            return null;
        }
        switch (columnType) {
            case 4: {
                Integer integer = (Integer)value;
                return integer.longValue();
            }
            case -6: 
            case 5: {
                return ((Integer)value).shortValue();
            }
            case 93: {
                return ((Timestamp)value).toLocalDateTime();
            }
            case 91: {
                return ((Date)value).toLocalDate();
            }
            case 92: {
                Time time = (Time)value;
                long epochMillis = time.getTime() + (long)TimeZone.getDefault().getOffset(time.getTime());
                return Instant.ofEpochMilli(epochMillis).atZone(ZoneId.of("UTC")).toLocalTime();
            }
        }
        return value;
    }

    public Schema getColumnSchema(int columnType, String typeName, int scale, int precision) {
        switch (columnType) {
            case -7: 
            case 16: {
                return SchemaConstants.BOOL_SCHEMA;
            }
            case -6: 
            case 5: {
                return SchemaConstants.SHORT_SCHEMA;
            }
            case -5: 
            case 4: {
                return SchemaConstants.LONG_SCHEMA;
            }
            case 7: {
                return SchemaConstants.FLOAT_SCHEMA;
            }
            case 6: 
            case 8: {
                return SchemaConstants.DOUBLE_SCHEMA;
            }
            case 2: 
            case 3: {
                return DecimalSchema.builder().scale(scale).precision(precision).build();
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return StringSchema.builder().maxLength(precision).build();
            }
            case 92: {
                return SchemaConstants.TIME_SCHEMA;
            }
            case 91: {
                return SchemaConstants.DATE_SCHEMA;
            }
            case 93: {
                return SchemaConstants.TIMESTAMP_SCHEMA;
            }
            case 2014: {
                return SchemaConstants.ZONED_TIMESTAMP_SCHEMA;
            }
        }
        log.warn("Unhandled sql type " + columnType);
        return null;
    }
}

