/*
 * Decompiled with CFR 0.152.
 */
package io.castled.pubsub;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.castled.kafka.KafkaApplicationConfig;
import io.castled.kafka.consumer.BaseKafkaConsumer;
import io.castled.kafka.consumer.KafkaConsumerConfiguration;
import io.castled.pubsub.MessageSubscriber;
import io.castled.pubsub.registry.Message;
import io.castled.utils.JsonUtils;
import java.util.List;
import java.util.UUID;
import org.apache.kafka.clients.consumer.ConsumerRecord;

@Singleton
public class PubSubConsumer
extends BaseKafkaConsumer {
    private final MessageSubscriber messageSubscriber;

    @Inject
    public PubSubConsumer(KafkaApplicationConfig kafkaApplicationConfig, MessageSubscriber messageSubscriber) {
        super(KafkaConsumerConfiguration.builder().bootstrapServers(kafkaApplicationConfig.getBootstrapServers()).consumerGroup(UUID.randomUUID().toString()).topic("pubsub_messages").retryOnUnhandledFailures(false).build());
        this.messageSubscriber = messageSubscriber;
    }

    @Override
    public long processRecords(List<ConsumerRecord<byte[], byte[]>> consumerRecords) throws Exception {
        long offset = -1L;
        for (ConsumerRecord<byte[], byte[]> consumerRecord : consumerRecords) {
            Message message = JsonUtils.byteArrayToObject((byte[])consumerRecord.value(), Message.class);
            this.messageSubscriber.consumeMessage(message);
            offset = consumerRecord.offset();
        }
        return offset;
    }
}

