/*
 * Decompiled with CFR 0.152.
 */
package io.castled.pubsub;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.castled.kafka.producer.CastledKafkaProducer;
import io.castled.pubsub.registry.Message;
import io.castled.utils.JsonUtils;
import java.util.UUID;
import org.apache.kafka.clients.producer.ProducerRecord;

@Singleton
public class MessagePublisher {
    private final CastledKafkaProducer castledKafkaProducer;

    @Inject
    public MessagePublisher(CastledKafkaProducer castledKafkaProducer) {
        this.castledKafkaProducer = castledKafkaProducer;
    }

    public void publishMessage(Message message) {
        ProducerRecord producerRecord = new ProducerRecord("pubsub_messages", null, (Object)UUID.randomUUID().toString().getBytes(), (Object)JsonUtils.objectToString(message).getBytes());
        this.castledKafkaProducer.publish((ProducerRecord<byte[], byte[]>)producerRecord);
    }
}

