/*
 * Decompiled with CFR 0.152.
 */
package io.castled.interceptors;

import io.castled.interceptors.Retry;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryInterceptor
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RetryInterceptor.class);

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Method method = methodInvocation.getMethod();
        Retry retry = method.getAnnotation(Retry.class);
        int attempt = 0;
        Class<? extends Exception>[] types = retry.types();
        while (true) {
            try {
                return methodInvocation.proceed();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw ex;
            }
            catch (Exception ex) {
                if (this.matches(ex.getClass(), retry.ignore()) || !this.matches(ex.getClass(), types)) {
                    throw ex;
                }
                if (++attempt >= retry.attempts()) {
                    log.warn(String.format("Failed after several retries. [%d] for [%s]", attempt, method.getName()), (Throwable)ex);
                    throw ex;
                }
                if (retry.waitTime() > 0L) {
                    Thread.sleep(retry.waitTime());
                }
                log.debug(String.format("Attempt [%d] for [%s] because of [%s]", attempt, method.getName(), ex.getMessage()));
                continue;
            }
            break;
        }
    }

    private boolean matches(Class<? extends Throwable> thrown, Class<? extends Throwable> ... types) {
        for (Class<? extends Throwable> type : types) {
            if (!type.isAssignableFrom(thrown)) continue;
            return true;
        }
        return false;
    }
}

