/*
 * Decompiled with CFR 0.152.
 */
package io.castled.filemanager;

import io.castled.exceptions.CastledRuntimeException;
import io.castled.filemanager.FileClosureListener;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawFileWriter
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(RawFileWriter.class);
    private final long maxFileSizeBytes;
    private final Path fileDirectory;
    private final Supplier<String> fileNameSupplier;
    private final FileClosureListener fileClosureListener;
    private FileChannel fileChannel;
    private Path currentFile;
    private static final byte[] LINE_SEPARATOR = System.lineSeparator().getBytes();
    private long bytesWritten = 0L;

    public RawFileWriter(long maxFileSizeBytes, Path fileDirectory, Supplier<String> fileNameSupplier) {
        this(maxFileSizeBytes, fileDirectory, fileNameSupplier, null);
    }

    public RawFileWriter(long maxFileSizeBytes, Path fileDirectory, Supplier<String> fileNameSupplier, FileClosureListener fileClosureListener) {
        try {
            this.maxFileSizeBytes = maxFileSizeBytes;
            this.fileDirectory = fileDirectory;
            this.fileNameSupplier = fileNameSupplier;
            this.fileClosureListener = fileClosureListener;
            if (!Files.exists(fileDirectory, new LinkOption[0])) {
                Files.createDirectories(fileDirectory, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new CastledRuntimeException(e);
        }
    }

    public void writeRecord(byte[] record) {
        try {
            if (this.fileChannel == null || !this.fileChannel.isOpen()) {
                String fileName = Optional.ofNullable(this.fileNameSupplier).map(Supplier::get).orElse(UUID.randomUUID().toString());
                this.currentFile = this.fileDirectory.resolve(fileName);
                this.fileChannel = new RandomAccessFile(this.currentFile.toFile(), "rw").getChannel();
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate(record.length + LINE_SEPARATOR.length);
            byteBuffer.put(record);
            byteBuffer.put(LINE_SEPARATOR);
            ((Buffer)byteBuffer).flip();
            this.fileChannel.write(byteBuffer);
            if (this.bytesWritten > this.maxFileSizeBytes) {
                this.closeCurrentFile();
            }
            this.bytesWritten += this.bytesWritten + (long)byteBuffer.position();
        }
        catch (IOException e) {
            log.error("Failed to write record {}", (Object)new String(record));
            throw new CastledRuntimeException(e);
        }
    }

    @Override
    public void close() throws Exception {
        this.closeCurrentFile();
    }

    public void closeCurrentFile() throws IOException {
        this.fileChannel.force(false);
        this.fileChannel.close();
        if (this.fileClosureListener != null) {
            this.fileClosureListener.onFileClosure(this.currentFile);
        }
    }
}

