/*
 * Decompiled with CFR 0.152.
 */
package io.castled.filemanager;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.QuoteMode;

public class CsvFileWriter {
    private final long maxRecords;
    private final Path fileDirectory;
    private final Supplier<String> fileNameSupplier;
    private final List<String> headerFields;
    private volatile CSVPrinter csvPrinter;
    private long recordCount = 0L;

    public CsvFileWriter(long maxRecords, Path fileDirectory, Supplier<String> fileNameSupplier, List<String> headerFields) throws IOException {
        this.maxRecords = maxRecords;
        this.fileDirectory = fileDirectory;
        this.fileNameSupplier = fileNameSupplier;
        this.headerFields = headerFields;
        if (!Files.exists(fileDirectory, new LinkOption[0])) {
            Files.createDirectories(fileDirectory, new FileAttribute[0]);
        }
    }

    public void writeRecord(List<Object> fieldValues) throws IOException {
        if (this.csvPrinter == null) {
            String fileName = Optional.ofNullable(this.fileNameSupplier).map(Supplier::get).orElse(UUID.randomUUID().toString());
            this.csvPrinter = new CSVPrinter((Appendable)new BufferedWriter(new FileWriter(this.fileDirectory.resolve(fileName).toFile())), CSVFormat.DEFAULT.withHeader(this.headerFields.toArray(new String[0])).withQuoteMode(QuoteMode.ALL));
        }
        this.csvPrinter.printRecord(fieldValues);
        ++this.recordCount;
        if (this.recordCount > this.maxRecords) {
            this.close();
        }
    }

    public void close() throws IOException {
        if (this.csvPrinter != null) {
            this.csvPrinter.flush();
            this.csvPrinter.close();
            this.csvPrinter = null;
        }
        this.recordCount = 0L;
    }
}

