/*
 * Decompiled with CFR 0.152.
 */
package io.castled.core;

import io.castled.functionalinterfaces.Action;
import io.castled.utils.ThreadUtils;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class IncessantRunner {
    private final ExecutorService executorService = Executors.newFixedThreadPool(1);
    private volatile boolean shutdown = false;

    public IncessantRunner(Action action, long sleepMs) {
        this.executorService.execute(() -> {
            while (!this.shutdown) {
                action.execute();
                ThreadUtils.interruptIgnoredSleep(sleepMs);
            }
        });
    }

    public void shutdown(long awaitMs) {
        this.shutdown = true;
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(awaitMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.executorService.shutdownNow();
        }
    }
}

