/*
 * Decompiled with CFR 0.152.
 */
package io.castled.core;

import com.google.common.collect.Sets;
import io.castled.core.CastledBlockingQueue;
import io.castled.schema.models.MessageOffsetSupplier;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.apache.commons.collections4.CollectionUtils;

public class CastledOffsetListQueue<T extends MessageOffsetSupplier>
extends CastledBlockingQueue<List<T>> {
    private final Set<Long> pendingMessageIds = Sets.newConcurrentHashSet();
    private long lastBufferedMessageId = 0L;

    public CastledOffsetListQueue(Consumer<List<T>> consumer, int parallelism, int maxCapacity, boolean exitOnError) {
        super(consumer, parallelism, maxCapacity, exitOnError);
    }

    @Override
    public void writePayload(List<T> messageList, int timeout, TimeUnit timeUnit) throws TimeoutException {
        if (CollectionUtils.isEmpty(messageList)) {
            return;
        }
        this.lastBufferedMessageId = ((MessageOffsetSupplier)messageList.get(messageList.size() - 1)).getOffset();
        messageList.forEach(message -> this.pendingMessageIds.add(message.getOffset()));
        super.writePayload(messageList, timeout, timeUnit);
    }

    @Override
    public Consumer<List<T>> decorateConsumer(Consumer<List<T>> consumer) {
        return messageList -> {
            consumer.accept((List<T>)messageList);
            messageList.forEach(message -> this.pendingMessageIds.remove(message.getOffset()));
        };
    }

    public long getProcessedOffset() {
        try {
            long currentMinPendingId = Collections.min(this.pendingMessageIds);
            return currentMinPendingId - 1L;
        }
        catch (NoSuchElementException e) {
            return this.lastBufferedMessageId;
        }
    }
}

