/*
 * Decompiled with CFR 0.152.
 */
package io.castled.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.castled.cache.CacheWrapper;
import io.castled.utils.TimeUtils;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class CastledCache<K, V> {
    private final Cache<K, CacheWrapper<V>> cache;
    private final Function<K, V> cacheLoader;
    private final boolean wrapNulls;

    public CastledCache(long ttlMs, long capacity, Function<K, V> cacheLoader, boolean wrapNulls) {
        this.cache = Caffeine.newBuilder().expireAfterWrite(this.adjustTTL(ttlMs), TimeUnit.MILLISECONDS).maximumSize(capacity).build();
        this.cacheLoader = cacheLoader;
        this.wrapNulls = wrapNulls;
    }

    public void write(K key, V value) {
        this.cache.put(key, new CacheWrapper<V>(value));
    }

    public V getValue(K key) {
        CacheWrapper cacheWrapper = (CacheWrapper)this.cache.get(key, keyRef -> {
            V value = this.cacheLoader.apply(keyRef);
            if (value != null || this.wrapNulls) {
                return new CacheWrapper<V>(value);
            }
            return null;
        });
        return Optional.ofNullable(cacheWrapper).map(CacheWrapper::getValue).orElse(null);
    }

    private long adjustTTL(long ttlMs) {
        long ttlDelta = new Random().nextInt(20) - 10;
        return ttlMs + TimeUtils.secondsToMillis(ttlDelta);
    }

    public V getValueIfPresent(K key) {
        CacheWrapper cacheWrapper = (CacheWrapper)this.cache.getIfPresent(key);
        return Optional.ofNullable(cacheWrapper).map(CacheWrapper::getValue).orElse(null);
    }

    public void invalidate(K key) {
        this.cache.invalidate(key);
    }
}

