/*
 * Decompiled with CFR 0.152.
 */
package io.cardell.openfeature.provider.java;

import cats.effect.kernel.Resource;
import cats.effect.kernel.Sync;
import cats.effect.kernel.Sync$;
import cats.syntax.package;
import dev.openfeature.sdk.FeatureProvider;
import dev.openfeature.sdk.ImmutableContext;
import dev.openfeature.sdk.ImmutableStructure;
import dev.openfeature.sdk.ProviderEvaluation;
import dev.openfeature.sdk.Reason;
import dev.openfeature.sdk.Value;
import io.cardell.openfeature.ErrorCode;
import io.cardell.openfeature.EvaluationContext;
import io.cardell.openfeature.FlagValue;
import io.cardell.openfeature.FlagValueType;
import io.cardell.openfeature.Structure;
import io.cardell.openfeature.StructureCodec;
import io.cardell.openfeature.StructureDecoder;
import io.cardell.openfeature.StructureDecoder$;
import io.cardell.openfeature.StructureDecoderError;
import io.cardell.openfeature.StructureEncoder$;
import io.cardell.openfeature.provider.EvaluationProvider;
import io.cardell.openfeature.provider.ProviderMetadata;
import io.cardell.openfeature.provider.ProviderMetadata$;
import io.cardell.openfeature.provider.ResolutionDetails$;
import io.cardell.openfeature.provider.java.FromJavaConverters$;
import io.cardell.openfeature.provider.java.JavaProvider$;
import io.cardell.openfeature.provider.java.ToJavaConverters$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.package$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class JavaProvider<F>
implements EvaluationProvider<F> {
    private final FeatureProvider provider;
    private final Sync<F> evidence$1;

    public static <F> Resource<F, JavaProvider<F>> resource(FeatureProvider featureProvider, Sync<F> sync) {
        return JavaProvider$.MODULE$.resource(featureProvider, sync);
    }

    public JavaProvider(FeatureProvider provider, Sync<F> evidence$1) {
        this.provider = provider;
        this.evidence$1 = evidence$1;
    }

    public ProviderMetadata metadata() {
        Option name = Option$.MODULE$.apply((Object)this.provider.getMetadata()).flatMap((Function1 & Serializable)m -> Option$.MODULE$.apply((Object)m.getName()).map((Function1 & Serializable)n -> n));
        return ProviderMetadata$.MODULE$.apply((String)name.getOrElse(JavaProvider::metadata$$anonfun$1));
    }

    public F resolveBooleanValue(String flagKey, boolean defaultValue, EvaluationContext context) {
        ImmutableContext jContext = ToJavaConverters$.MODULE$.evaluationContext(context);
        Object providerResolution = Sync$.MODULE$.apply(this.evidence$1).blocking(() -> this.$anonfun$2(flagKey, defaultValue, jContext));
        return (F)package.all$.MODULE$.toFunctorOps(providerResolution, this.evidence$1).map((Function1 & Serializable)_$2 -> FromJavaConverters$.MODULE$.evaluation(_$2, (Function1 & Serializable)_$3 -> _$3));
    }

    public F resolveStringValue(String flagKey, String defaultValue, EvaluationContext context) {
        ImmutableContext jContext = ToJavaConverters$.MODULE$.evaluationContext(context);
        Object providerResolution = Sync$.MODULE$.apply(this.evidence$1).blocking(() -> this.$anonfun$3(flagKey, defaultValue, jContext));
        return (F)package.all$.MODULE$.toFunctorOps(providerResolution, this.evidence$1).map((Function1 & Serializable)_$4 -> FromJavaConverters$.MODULE$.evaluation(_$4));
    }

    public F resolveIntValue(String flagKey, int defaultValue, EvaluationContext context) {
        ImmutableContext jContext = ToJavaConverters$.MODULE$.evaluationContext(context);
        Object providerResolution = Sync$.MODULE$.apply(this.evidence$1).blocking(() -> this.$anonfun$4(flagKey, defaultValue, jContext));
        return (F)package.all$.MODULE$.toFunctorOps(providerResolution, this.evidence$1).map((Function1 & Serializable)_$5 -> FromJavaConverters$.MODULE$.evaluation(_$5, (Function1 & Serializable)_$6 -> Predef$.MODULE$.Integer2int(_$6)));
    }

    public F resolveDoubleValue(String flagKey, double defaultValue, EvaluationContext context) {
        ImmutableContext jContext = ToJavaConverters$.MODULE$.evaluationContext(context);
        Object providerResolution = Sync$.MODULE$.apply(this.evidence$1).blocking(() -> this.$anonfun$5(flagKey, defaultValue, jContext));
        return (F)package.all$.MODULE$.toFunctorOps(providerResolution, this.evidence$1).map((Function1 & Serializable)_$7 -> FromJavaConverters$.MODULE$.evaluation(_$7, (Function1 & Serializable)_$8 -> Predef$.MODULE$.Double2double(_$8)));
    }

    public <A> F resolveStructureValue(String flagKey, A defaultValue, EvaluationContext context, StructureCodec<A> evidence$1) {
        ImmutableContext jContext = ToJavaConverters$.MODULE$.evaluationContext(context);
        Structure defaultStructure = StructureEncoder$.MODULE$.apply(evidence$1).encodeStructure(defaultValue);
        ImmutableStructure jStructure = ToJavaConverters$.MODULE$.structure(defaultStructure);
        Object providerResolution = Sync$.MODULE$.apply(this.evidence$1).blocking(() -> this.$anonfun$6(flagKey, jStructure, jContext));
        return (F)package.all$.MODULE$.toFunctorOps(providerResolution, this.evidence$1).map((Function1 & Serializable)x$1 -> {
            Left maybeStructure;
            Left left;
            ProviderEvaluation providerEvaluation = x$1;
            ProviderEvaluation jResolution = providerEvaluation;
            FlagValue flagValue = FromJavaConverters$.MODULE$.value((Value)jResolution.getValue());
            FlagValue flagValue2 = flagValue;
            if (flagValue2 instanceof FlagValue.StructureValue) {
                Structure structure;
                FlagValue.StructureValue structureValue = FlagValue.StructureValue$.MODULE$.unapply((FlagValue.StructureValue)flagValue2);
                Structure structure2 = structure = structureValue._1();
                left = package$.MODULE$.Right().apply((Object)structure2);
            } else {
                FlagValue otherType = flagValue2;
                left = package$.MODULE$.Left().apply((Object)otherType.valueType());
            }
            Left left2 = maybeStructure = left;
            if (left2 instanceof Left) {
                FlagValueType wrongType = (FlagValueType)left2.value();
                return ResolutionDetails$.MODULE$.error(defaultValue, new StringBuilder(21).append("Wrong type, received ").append(wrongType).toString(), (ErrorCode)ErrorCode.TypeMismatch$.MODULE$);
            }
            if (left2 instanceof Right) {
                Structure struct = (Structure)((Right)left2).value();
                Either maybeValue = StructureDecoder$.MODULE$.apply((StructureDecoder)evidence$1).decodeStructure(struct);
                Either either = maybeValue;
                if (either instanceof Left) {
                    StructureDecoderError error = (StructureDecoderError)((Left)either).value();
                    return ResolutionDetails$.MODULE$.fromThrowable(defaultValue, error.cause(), (ErrorCode)ErrorCode.TypeMismatch$.MODULE$);
                }
                if (either instanceof Right) {
                    Object value = ((Right)either).value();
                    Option option = Option$.MODULE$.apply((Object)jResolution.getReason()).map((Function1 & Serializable)x$0 -> Reason.valueOf((String)x$0)).map((Function1 & Serializable)reason -> FromJavaConverters$.MODULE$.reason((Reason)reason));
                    Option option2 = Option$.MODULE$.apply((Object)jResolution.getErrorCode()).map((Function1 & Serializable)ec -> FromJavaConverters$.MODULE$.errorCode((dev.openfeature.sdk.ErrorCode)ec));
                    Option option3 = Option$.MODULE$.apply((Object)jResolution.getErrorMessage());
                    Option option4 = Option$.MODULE$.apply((Object)jResolution.getVariant());
                    None$ none$ = None$.MODULE$;
                    return ResolutionDetails$.MODULE$.apply(value, option2, option3, option, option4, (Option)none$);
                }
                throw new MatchError((Object)either);
            }
            throw new MatchError((Object)left2);
        });
    }

    private static final String metadata$$anonfun$1() {
        return "unknown-java-provider";
    }

    private final ProviderEvaluation $anonfun$2(String flagKey$1, boolean defaultValue$1, ImmutableContext jContext$1) {
        return this.provider.getBooleanEvaluation(flagKey$1, Predef$.MODULE$.boolean2Boolean(defaultValue$1), (dev.openfeature.sdk.EvaluationContext)jContext$1);
    }

    private final ProviderEvaluation $anonfun$3(String flagKey$2, String defaultValue$2, ImmutableContext jContext$2) {
        return this.provider.getStringEvaluation(flagKey$2, defaultValue$2, (dev.openfeature.sdk.EvaluationContext)jContext$2);
    }

    private final ProviderEvaluation $anonfun$4(String flagKey$3, int defaultValue$3, ImmutableContext jContext$3) {
        return this.provider.getIntegerEvaluation(flagKey$3, Predef$.MODULE$.int2Integer(defaultValue$3), (dev.openfeature.sdk.EvaluationContext)jContext$3);
    }

    private final ProviderEvaluation $anonfun$5(String flagKey$4, double defaultValue$4, ImmutableContext jContext$4) {
        return this.provider.getDoubleEvaluation(flagKey$4, Predef$.MODULE$.double2Double(defaultValue$4), (dev.openfeature.sdk.EvaluationContext)jContext$4);
    }

    private final ProviderEvaluation $anonfun$6(String flagKey$5, ImmutableStructure jStructure$1, ImmutableContext jContext$5) {
        return this.provider.getObjectEvaluation(flagKey$5, new Value((dev.openfeature.sdk.Structure)jStructure$1), (dev.openfeature.sdk.EvaluationContext)jContext$5);
    }
}

