/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util;

import io.camunda.zeebe.util.Loggers;
import io.camunda.zeebe.util.StringUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;

public final class Environment {
    private static final Logger LOG = Loggers.CONFIG_LOGGER;
    private final Map<String, String> environment;

    public Environment() {
        this(System.getenv());
    }

    public Environment(Map<String, String> environment) {
        this.environment = environment;
    }

    public Set<String> getPropertyKeys() {
        return Collections.unmodifiableSet(this.environment.keySet());
    }

    public Optional<String> get(String name) {
        return Optional.ofNullable(this.environment.get(name));
    }

    public Optional<Integer> getInt(String name) {
        try {
            return this.get(name).map(Integer::valueOf);
        }
        catch (Exception e) {
            LOG.warn("Failed to parse environment variable {}", (Object)name, (Object)e);
            return Optional.empty();
        }
    }

    public Optional<Double> getDouble(String name) {
        try {
            return this.get(name).map(Double::valueOf);
        }
        catch (Exception e) {
            LOG.warn("Failed to parse environment variable {}", (Object)name, (Object)e);
            return Optional.empty();
        }
    }

    public Optional<Long> getLong(String name) {
        try {
            return this.get(name).map(Long::valueOf);
        }
        catch (Exception e) {
            LOG.warn("Failed to parse environment variable {}", (Object)name, (Object)e);
            return Optional.empty();
        }
    }

    public Optional<Boolean> getBool(String name) {
        try {
            return this.get(name).map(Boolean::valueOf);
        }
        catch (Exception e) {
            LOG.warn("Failed to parse environment variable {}", (Object)name, (Object)e);
            return Optional.empty();
        }
    }

    public Optional<List<String>> getList(String name) {
        return this.get(name).map(v -> v.split(",")).map(Arrays::asList).map(StringUtil.LIST_SANITIZER);
    }
}

