/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.stream.impl.messages;

import io.camunda.zeebe.transport.stream.impl.messages.MessageHeaderDecoder;
import io.camunda.zeebe.transport.stream.impl.messages.MessageHeaderEncoder;
import io.camunda.zeebe.transport.stream.impl.messages.PushStreamResponseDecoder;
import io.camunda.zeebe.transport.stream.impl.messages.PushStreamResponseEncoder;
import io.camunda.zeebe.transport.stream.impl.messages.StreamResponse;
import io.camunda.zeebe.util.buffer.BufferReader;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class PushStreamResponse
implements BufferReader,
StreamResponse {
    private final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    private final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    private final PushStreamResponseEncoder messageEncoder = new PushStreamResponseEncoder();
    private final PushStreamResponseDecoder messageDecoder = new PushStreamResponseDecoder();

    public void wrap(DirectBuffer buffer, int offset, int length) {
        this.messageDecoder.wrapAndApplyHeader(buffer, offset, this.headerDecoder);
    }

    public int getLength() {
        return this.headerEncoder.encodedLength() + this.messageEncoder.sbeBlockLength();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.messageEncoder.wrapAndApplyHeader(buffer, offset, this.headerEncoder);
    }

    @Override
    public int templateId() {
        return this.messageDecoder.sbeTemplateId();
    }

    public String toString() {
        return "PushStreamResponse{}";
    }
}

