/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.stream.impl;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.transport.stream.api.RemoteStreamMetrics;
import io.camunda.zeebe.transport.stream.impl.AggregatedRemoteStream;
import io.camunda.zeebe.transport.stream.impl.ImmutableStreamRegistry;
import io.camunda.zeebe.transport.stream.impl.LogicalId;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.agrona.concurrent.UnsafeBuffer;

public class RemoteStreamRegistry<M>
implements ImmutableStreamRegistry<M> {
    private final RemoteStreamMetrics metrics;
    private final ConcurrentMap<UnsafeBuffer, Set<AggregatedRemoteStream<M>>> typeToConsumers = new ConcurrentHashMap<UnsafeBuffer, Set<AggregatedRemoteStream<M>>>();
    private final ConcurrentMap<LogicalId<M>, AggregatedRemoteStream<M>> logicalIdToConsumers = new ConcurrentHashMap<LogicalId<M>, AggregatedRemoteStream<M>>();
    private final Map<AggregatedRemoteStream.StreamId, AggregatedRemoteStream.StreamConsumer<M>> idToConsumer = new HashMap<AggregatedRemoteStream.StreamId, AggregatedRemoteStream.StreamConsumer<M>>();

    public RemoteStreamRegistry(RemoteStreamMetrics metrics) {
        this.metrics = metrics;
    }

    public void add(UnsafeBuffer streamType, UUID streamId, MemberId receiver, M properties) {
        AggregatedRemoteStream.StreamId uniqueId = new AggregatedRemoteStream.StreamId(streamId, receiver);
        if (this.idToConsumer.containsKey(uniqueId)) {
            return;
        }
        this.typeToConsumers.putIfAbsent(streamType, new CopyOnWriteArraySet());
        LogicalId<M> logicalId = new LogicalId<M>(streamType, properties);
        this.logicalIdToConsumers.computeIfAbsent(logicalId, id -> {
            AggregatedRemoteStream aggregatedStream = new AggregatedRemoteStream(logicalId, new CopyOnWriteArrayList());
            ((Set)this.typeToConsumers.get(streamType)).add(aggregatedStream);
            return aggregatedStream;
        });
        AggregatedRemoteStream.StreamConsumer<M> streamConsumer = new AggregatedRemoteStream.StreamConsumer<M>(uniqueId, logicalId);
        ((AggregatedRemoteStream)this.logicalIdToConsumers.get(logicalId)).addConsumer(streamConsumer);
        this.idToConsumer.put(uniqueId, streamConsumer);
        this.metrics.addStream();
    }

    public void remove(UUID streamId, MemberId receiver) {
        AggregatedRemoteStream.StreamId uniqueId = new AggregatedRemoteStream.StreamId(streamId, receiver);
        AggregatedRemoteStream.StreamConsumer<M> consumer = this.idToConsumer.remove(uniqueId);
        if (consumer != null) {
            this.logicalIdToConsumers.computeIfPresent(consumer.logicalId(), (id, aggregatedStream) -> {
                aggregatedStream.removeConsumer(consumer);
                if (aggregatedStream.streamConsumers().isEmpty()) {
                    ((Set)this.typeToConsumers.get(consumer.logicalId().streamType())).remove(aggregatedStream);
                    return null;
                }
                return aggregatedStream;
            });
            this.metrics.removeStream();
        }
    }

    public void removeAll(MemberId receiver) {
        List<AggregatedRemoteStream.StreamId> streamOfReceiver = this.idToConsumer.keySet().stream().filter(id -> id.receiver().equals((Object)receiver)).toList();
        streamOfReceiver.forEach(stream -> this.remove(stream.streamId(), stream.receiver()));
    }

    @Override
    public Set<AggregatedRemoteStream<M>> get(UnsafeBuffer streamType) {
        return this.typeToConsumers.getOrDefault(streamType, Collections.emptySet());
    }

    public void clear() {
        this.typeToConsumers.clear();
        this.idToConsumer.clear();
        this.logicalIdToConsumers.clear();
    }

    Collection<AggregatedRemoteStream<M>> list() {
        return this.logicalIdToConsumers.values();
    }
}

