/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.stream.impl;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.transport.stream.api.RemoteStreamInfo;
import io.camunda.zeebe.transport.stream.impl.LogicalId;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.agrona.DirectBuffer;

record AggregatedRemoteStream<M>(LogicalId<M> logicalId, List<StreamConsumer<M>> streamConsumers) implements RemoteStreamInfo<M>
{
    void addConsumer(StreamConsumer<M> consumer) {
        this.streamConsumers.add(consumer);
    }

    void removeConsumer(StreamConsumer<M> consumer) {
        this.streamConsumers.remove(consumer);
    }

    @Override
    public Collection<RemoteStreamInfo.RemoteStreamId> consumers() {
        return this.streamConsumers.stream().map(StreamConsumer::id).collect(Collectors.toSet());
    }

    @Override
    public DirectBuffer streamType() {
        return this.logicalId().streamType();
    }

    @Override
    public M metadata() {
        return this.logicalId.metadata();
    }

    record StreamId(UUID streamId, MemberId receiver) implements RemoteStreamInfo.RemoteStreamId
    {
    }

    record StreamConsumer<M>(StreamId id, LogicalId<M> logicalId) {
    }
}

