/* Generated SBE (Simple Binary Encoding) message codec. */
package io.camunda.zeebe.transport.stream.impl.messages;

import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.*;


/**
 * Universally Unique ID
 */
@SuppressWarnings("all")
public final class UUIDEncoder implements CompositeEncoderFlyweight
{
    public static final int SCHEMA_ID = 2;
    public static final int SCHEMA_VERSION = 2;
    public static final String SEMANTIC_VERSION = "8.8.0-alpha8";
    public static final int ENCODED_LENGTH = 16;
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private int offset;
    private MutableDirectBuffer buffer;

    public UUIDEncoder wrap(final MutableDirectBuffer buffer, final int offset)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.offset = offset;

        return this;
    }

    public MutableDirectBuffer buffer()
    {
        return buffer;
    }

    public int offset()
    {
        return offset;
    }

    public int encodedLength()
    {
        return ENCODED_LENGTH;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public static int highEncodingOffset()
    {
        return 0;
    }

    public static int highEncodingLength()
    {
        return 8;
    }

    public static long highNullValue()
    {
        return -9223372036854775808L;
    }

    public static long highMinValue()
    {
        return -9223372036854775807L;
    }

    public static long highMaxValue()
    {
        return 9223372036854775807L;
    }

    public UUIDEncoder high(final long value)
    {
        buffer.putLong(offset + 0, value, BYTE_ORDER);
        return this;
    }


    public static int lowEncodingOffset()
    {
        return 8;
    }

    public static int lowEncodingLength()
    {
        return 8;
    }

    public static long lowNullValue()
    {
        return -9223372036854775808L;
    }

    public static long lowMinValue()
    {
        return -9223372036854775807L;
    }

    public static long lowMaxValue()
    {
        return 9223372036854775807L;
    }

    public UUIDEncoder low(final long value)
    {
        buffer.putLong(offset + 8, value, BYTE_ORDER);
        return this;
    }


    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        return appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final UUIDDecoder decoder = new UUIDDecoder();
        decoder.wrap(buffer, offset);

        return decoder.appendTo(builder);
    }
}
