/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.stream.impl.messages;

import io.camunda.zeebe.transport.stream.impl.messages.ErrorCode;
import io.camunda.zeebe.transport.stream.impl.messages.MessageHeaderDecoder;
import io.camunda.zeebe.transport.stream.impl.messages.MetaAttribute;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public final class ErrorResponseDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 1;
    public static final int TEMPLATE_ID = 406;
    public static final int SCHEMA_ID = 2;
    public static final int SCHEMA_VERSION = 2;
    public static final String SEMANTIC_VERSION = "8.7.16";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ErrorResponseDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;
    private final DetailsDecoder details = new DetailsDecoder(this);

    public int sbeBlockLength() {
        return 1;
    }

    public int sbeTemplateId() {
        return 406;
    }

    public int sbeSchemaId() {
        return 2;
    }

    public int sbeSchemaVersion() {
        return 2;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public ErrorResponseDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public ErrorResponseDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (406 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public ErrorResponseDecoder sbeRewind() {
        return this.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int actingVersion() {
        return this.actingVersion;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int codeId() {
        return 1;
    }

    public static int codeSinceVersion() {
        return 0;
    }

    public static int codeEncodingOffset() {
        return 0;
    }

    public static int codeEncodingLength() {
        return 1;
    }

    public static String codeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public short codeRaw() {
        return (short)(this.buffer.getByte(this.offset + 0) & 0xFF);
    }

    public ErrorCode code() {
        return ErrorCode.get((short)(this.buffer.getByte(this.offset + 0) & 0xFF));
    }

    public static long detailsDecoderId() {
        return 2L;
    }

    public static int detailsDecoderSinceVersion() {
        return 0;
    }

    public DetailsDecoder details() {
        this.details.wrap(this.buffer);
        return this.details;
    }

    public static int messageId() {
        return 5;
    }

    public static int messageSinceVersion() {
        return 0;
    }

    public static String messageCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String messageMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int messageHeaderLength() {
        return 4;
    }

    public int messageLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
    }

    public int skipMessage() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getMessage(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getMessage(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapMessage(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String message() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        ErrorResponseDecoder decoder = new ErrorResponseDecoder();
        decoder.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[ErrorResponse](sbeTemplateId=");
        builder.append(406);
        builder.append("|sbeSchemaId=");
        builder.append(2);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 2) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(2);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 1) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(1);
        builder.append("):");
        builder.append("code=");
        builder.append((Object)this.code());
        builder.append('|');
        builder.append("details=[");
        int detailsOriginalOffset = this.details.offset;
        int detailsOriginalIndex = this.details.index;
        DetailsDecoder details = this.details();
        if (details.count() > 0) {
            while (details.hasNext()) {
                details.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        details.offset = detailsOriginalOffset;
        details.index = detailsOriginalIndex;
        builder.append(']');
        builder.append('|');
        builder.append("message=");
        builder.append('\'').append(this.message()).append('\'');
        this.limit(originalLimit);
        return builder;
    }

    public ErrorResponseDecoder sbeSkip() {
        this.sbeRewind();
        DetailsDecoder details = this.details();
        if (details.count() > 0) {
            while (details.hasNext()) {
                details.next();
                details.sbeSkip();
            }
        }
        this.skipMessage();
        return this;
    }

    public static final class DetailsDecoder
    implements Iterable<DetailsDecoder>,
    Iterator<DetailsDecoder> {
        public static final int HEADER_SIZE = 3;
        private final ErrorResponseDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        DetailsDecoder(ErrorResponseDecoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(DirectBuffer buffer) {
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            this.blockLength = buffer.getShort(limit + 0, BYTE_ORDER) & 0xFFFF;
            this.count = (short)(buffer.getByte(limit + 2) & 0xFF);
        }

        @Override
        public DetailsDecoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 1;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int actingVersion() {
            return this.parentMessage.actingVersion;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<DetailsDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.count;
        }

        public static int codeId() {
            return 3;
        }

        public static int codeSinceVersion() {
            return 0;
        }

        public static int codeEncodingOffset() {
            return 0;
        }

        public static int codeEncodingLength() {
            return 1;
        }

        public static String codeMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public short codeRaw() {
            return (short)(this.buffer.getByte(this.offset + 0) & 0xFF);
        }

        public ErrorCode code() {
            return ErrorCode.get((short)(this.buffer.getByte(this.offset + 0) & 0xFF));
        }

        public static int messageId() {
            return 4;
        }

        public static int messageSinceVersion() {
            return 0;
        }

        public static String messageCharacterEncoding() {
            return StandardCharsets.UTF_8.name();
        }

        public static String messageMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int messageHeaderLength() {
            return 4;
        }

        public int messageLength() {
            int limit = this.parentMessage.limit();
            return (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        }

        public int skipMessage() {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
            int dataOffset = limit + 4;
            this.parentMessage.limit(dataOffset + dataLength);
            return dataLength;
        }

        public int getMessage(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getMessage(byte[] dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public void wrapMessage(DirectBuffer wrapBuffer) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
        }

        public String message() {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            if (0 == dataLength) {
                return "";
            }
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
            return new String(tmp, StandardCharsets.UTF_8);
        }

        public StringBuilder appendTo(StringBuilder builder) {
            if (null == this.buffer) {
                return builder;
            }
            builder.append('(');
            builder.append("code=");
            builder.append((Object)this.code());
            builder.append('|');
            builder.append("message=");
            builder.append('\'').append(this.message()).append('\'');
            builder.append(')');
            return builder;
        }

        public DetailsDecoder sbeSkip() {
            this.skipMessage();
            return this;
        }
    }
}

