/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.stream.impl.messages;

import io.camunda.zeebe.transport.stream.api.ClientStreamBlockedException;
import io.camunda.zeebe.transport.stream.api.NoSuchStreamException;
import io.camunda.zeebe.transport.stream.api.StreamExhaustedException;
import io.camunda.zeebe.transport.stream.api.StreamResponseException;
import io.camunda.zeebe.transport.stream.impl.messages.ErrorCode;
import io.camunda.zeebe.transport.stream.impl.messages.ErrorResponseDecoder;
import io.camunda.zeebe.transport.stream.impl.messages.ErrorResponseEncoder;
import io.camunda.zeebe.transport.stream.impl.messages.MessageHeaderDecoder;
import io.camunda.zeebe.transport.stream.impl.messages.MessageHeaderEncoder;
import io.camunda.zeebe.transport.stream.impl.messages.StreamResponse;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class ErrorResponse
implements StreamResponse {
    private final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    private final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    private final ErrorResponseEncoder messageEncoder = new ErrorResponseEncoder();
    private final ErrorResponseDecoder messageDecoder = new ErrorResponseDecoder();
    private final List<ErrorDetailImpl> details = new ArrayList<ErrorDetailImpl>();
    private final DirectBuffer message = new UnsafeBuffer();
    private ErrorCode code;

    public void wrap(DirectBuffer buffer, int offset, int length) {
        this.messageDecoder.wrapAndApplyHeader(buffer, offset, this.headerDecoder);
        this.code = this.messageDecoder.code();
        this.messageDecoder.wrapMessage(this.message);
        this.details.clear();
        for (ErrorResponseDecoder.DetailsDecoder decoder : this.messageDecoder.details()) {
            UnsafeBuffer messageBuffer = new UnsafeBuffer();
            ErrorDetailImpl detail = new ErrorDetailImpl(decoder.code(), (DirectBuffer)messageBuffer);
            decoder.wrapMessage((DirectBuffer)messageBuffer);
            this.details.add(detail);
        }
    }

    public int getLength() {
        int detailsLength = this.details.stream().mapToInt(e -> ErrorResponseEncoder.DetailsEncoder.sbeBlockLength() + ErrorResponseEncoder.DetailsEncoder.messageHeaderLength() + e.messageBuffer.capacity()).sum();
        return this.headerEncoder.encodedLength() + this.messageEncoder.sbeBlockLength() + ErrorResponseEncoder.DetailsEncoder.sbeHeaderSize() + detailsLength + ErrorResponseEncoder.messageHeaderLength() + this.message.capacity();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.messageEncoder.wrapAndApplyHeader(buffer, offset, this.headerEncoder).code(this.code).putMessage(this.message, 0, this.message.capacity());
        ErrorResponseEncoder.DetailsEncoder detailsEncoder = this.messageEncoder.detailsCount(this.details.size());
        this.details.forEach(detail -> detailsEncoder.next().code(detail.code()).putMessage(detail.messageBuffer(), 0, detail.messageBuffer().capacity()));
    }

    @Override
    public int templateId() {
        return this.messageDecoder.sbeTemplateId();
    }

    public ErrorResponse code(ErrorCode code) {
        this.code = code;
        return this;
    }

    public ErrorResponse message(DirectBuffer message) {
        this.message.wrap(message);
        return this;
    }

    public ErrorResponse message(String message) {
        byte[] bytes = message.getBytes(StandardCharsets.UTF_8);
        this.message.wrap(bytes);
        return this;
    }

    public ErrorCode code() {
        return this.code;
    }

    public String message() {
        return this.message.capacity() > 0 ? BufferUtil.bufferAsString((DirectBuffer)this.message) : "";
    }

    public ErrorResponse addDetail(ErrorCode code, String message) {
        this.details.add(new ErrorDetailImpl(code, (DirectBuffer)new UnsafeBuffer(message.getBytes(StandardCharsets.UTF_8))));
        return this;
    }

    public List<? extends StreamResponseException.ErrorDetail> details() {
        return this.details;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.message, this.code});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorResponse that = (ErrorResponse)o;
        return Objects.equals(this.message, that.message) && this.code == that.code;
    }

    public String toString() {
        return "ErrorResponse{message=" + this.message() + ", code=" + String.valueOf((Object)this.code) + ", details=" + String.valueOf(this.details) + "}";
    }

    public StreamResponseException asException() {
        return new StacklessException(this);
    }

    public static ErrorCode mapErrorToCode(Throwable error) {
        Throwable throwable = error;
        Objects.requireNonNull(throwable);
        Throwable throwable2 = throwable;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClientStreamBlockedException.class, NoSuchStreamException.class, StreamExhaustedException.class}, (Object)throwable2, n)) {
            case 0 -> {
                ClientStreamBlockedException ignored = (ClientStreamBlockedException)throwable2;
                yield ErrorCode.BLOCKED;
            }
            case 1 -> {
                NoSuchStreamException ignored = (NoSuchStreamException)throwable2;
                yield ErrorCode.NOT_FOUND;
            }
            case 2 -> {
                StreamExhaustedException ignored = (StreamExhaustedException)throwable2;
                yield ErrorCode.EXHAUSTED;
            }
            default -> ErrorCode.INTERNAL;
        };
    }

    private record ErrorDetailImpl(ErrorCode code, DirectBuffer messageBuffer) implements StreamResponseException.ErrorDetail
    {
        @Override
        public String message() {
            int length = this.messageBuffer.capacity();
            return length == 0 ? "" : this.messageBuffer.getStringWithoutLengthUtf8(0, length);
        }

        @Override
        public String toString() {
            return "ErrorDetailImpl{code=" + String.valueOf((Object)this.code) + ", message=" + this.message() + "}";
        }
    }

    private static final class StacklessException
    extends StreamResponseException {
        private StacklessException(ErrorResponse response) {
            super(response);
        }

        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

