/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.stream.impl.messages;

import io.camunda.zeebe.transport.stream.impl.messages.ErrorCode;
import io.camunda.zeebe.transport.stream.impl.messages.ErrorResponseDecoder;
import io.camunda.zeebe.transport.stream.impl.messages.MessageHeaderEncoder;
import io.camunda.zeebe.transport.stream.impl.messages.MetaAttribute;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayUtil;
import org.agrona.sbe.MessageEncoderFlyweight;

public final class ErrorResponseEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 1;
    public static final int TEMPLATE_ID = 406;
    public static final int SCHEMA_ID = 2;
    public static final int SCHEMA_VERSION = 2;
    public static final String SEMANTIC_VERSION = "8.7.12";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ErrorResponseEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;
    private final DetailsEncoder details = new DetailsEncoder(this);

    public int sbeBlockLength() {
        return 1;
    }

    public int sbeTemplateId() {
        return 406;
    }

    public int sbeSchemaId() {
        return 2;
    }

    public int sbeSchemaVersion() {
        return 2;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public ErrorResponseEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 1);
        return this;
    }

    public ErrorResponseEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(1).templateId(406).schemaId(2).version(2);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int codeId() {
        return 1;
    }

    public static int codeSinceVersion() {
        return 0;
    }

    public static int codeEncodingOffset() {
        return 0;
    }

    public static int codeEncodingLength() {
        return 1;
    }

    public static String codeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public ErrorResponseEncoder code(ErrorCode value) {
        this.buffer.putByte(this.offset + 0, (byte)value.value());
        return this;
    }

    public static long detailsId() {
        return 2L;
    }

    public DetailsEncoder detailsCount(int count) {
        this.details.wrap(this.buffer, count);
        return this.details;
    }

    public static int messageId() {
        return 5;
    }

    public static String messageCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String messageMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int messageHeaderLength() {
        return 4;
    }

    public ErrorResponseEncoder putMessage(DirectBuffer src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public ErrorResponseEncoder putMessage(byte[] src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public ErrorResponseEncoder message(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        ErrorResponseDecoder decoder = new ErrorResponseDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.offset, 1, 2);
        return decoder.appendTo(builder);
    }

    public static final class DetailsEncoder {
        public static final int HEADER_SIZE = 3;
        private final ErrorResponseEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        DetailsEncoder(ErrorResponseEncoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(MutableDirectBuffer buffer, int count) {
            int limit;
            if (count < 0 || count > 254) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            this.count = count;
            this.initialLimit = limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            buffer.putShort(limit + 0, (short)1, BYTE_ORDER);
            buffer.putByte(limit + 2, (byte)count);
        }

        public DetailsEncoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + DetailsEncoder.sbeBlockLength());
            ++this.index;
            return this;
        }

        public int resetCountToIndex() {
            this.count = this.index;
            this.buffer.putByte(this.initialLimit + 2, (byte)this.count);
            return this.count;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 1;
        }

        public static int codeId() {
            return 3;
        }

        public static int codeSinceVersion() {
            return 0;
        }

        public static int codeEncodingOffset() {
            return 0;
        }

        public static int codeEncodingLength() {
            return 1;
        }

        public static String codeMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public DetailsEncoder code(ErrorCode value) {
            this.buffer.putByte(this.offset + 0, (byte)value.value());
            return this;
        }

        public static int messageId() {
            return 4;
        }

        public static String messageCharacterEncoding() {
            return StandardCharsets.UTF_8.name();
        }

        public static String messageMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int messageHeaderLength() {
            return 4;
        }

        public DetailsEncoder putMessage(DirectBuffer src, int srcOffset, int length) {
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, BYTE_ORDER);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public DetailsEncoder putMessage(byte[] src, int srcOffset, int length) {
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, BYTE_ORDER);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public DetailsEncoder message(String value) {
            byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
            int length = bytes.length;
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, BYTE_ORDER);
            this.buffer.putBytes(limit + 4, bytes, 0, length);
            return this;
        }
    }
}

