/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.stream.impl.messages;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.sbe.CompositeDecoderFlyweight;

public final class UUIDDecoder
implements CompositeDecoderFlyweight {
    public static final int SCHEMA_ID = 2;
    public static final int SCHEMA_VERSION = 2;
    public static final String SEMANTIC_VERSION = "8.6.28";
    public static final int ENCODED_LENGTH = 16;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private int offset;
    private DirectBuffer buffer;

    public UUIDDecoder wrap(DirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        return this;
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public int encodedLength() {
        return 16;
    }

    public int sbeSchemaId() {
        return 2;
    }

    public int sbeSchemaVersion() {
        return 2;
    }

    public static int highEncodingOffset() {
        return 0;
    }

    public static int highEncodingLength() {
        return 8;
    }

    public static int highSinceVersion() {
        return 0;
    }

    public static long highNullValue() {
        return Long.MIN_VALUE;
    }

    public static long highMinValue() {
        return -9223372036854775807L;
    }

    public static long highMaxValue() {
        return Long.MAX_VALUE;
    }

    public long high() {
        return this.buffer.getLong(this.offset + 0, BYTE_ORDER);
    }

    public static int lowEncodingOffset() {
        return 8;
    }

    public static int lowEncodingLength() {
        return 8;
    }

    public static int lowSinceVersion() {
        return 0;
    }

    public static long lowNullValue() {
        return Long.MIN_VALUE;
    }

    public static long lowMinValue() {
        return -9223372036854775807L;
    }

    public static long lowMaxValue() {
        return Long.MAX_VALUE;
    }

    public long low() {
        return this.buffer.getLong(this.offset + 8, BYTE_ORDER);
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        builder.append('(');
        builder.append("high=");
        builder.append(this.high());
        builder.append('|');
        builder.append("low=");
        builder.append(this.low());
        builder.append(')');
        return builder;
    }
}

