/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.stream.impl.messages;

import io.camunda.zeebe.transport.stream.impl.messages.MessageHeaderDecoder;
import io.camunda.zeebe.transport.stream.impl.messages.MetaAttribute;
import io.camunda.zeebe.transport.stream.impl.messages.UUIDDecoder;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public final class AddStreamRequestDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 16;
    public static final int TEMPLATE_ID = 400;
    public static final int SCHEMA_ID = 2;
    public static final int SCHEMA_VERSION = 2;
    public static final String SEMANTIC_VERSION = "8.6.26";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final AddStreamRequestDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;
    private final UUIDDecoder id = new UUIDDecoder();

    public int sbeBlockLength() {
        return 16;
    }

    public int sbeTemplateId() {
        return 400;
    }

    public int sbeSchemaId() {
        return 2;
    }

    public int sbeSchemaVersion() {
        return 2;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public AddStreamRequestDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public AddStreamRequestDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (400 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public AddStreamRequestDecoder sbeRewind() {
        return this.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int actingVersion() {
        return this.actingVersion;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int idId() {
        return 1;
    }

    public static int idSinceVersion() {
        return 0;
    }

    public static int idEncodingOffset() {
        return 0;
    }

    public static int idEncodingLength() {
        return 16;
    }

    public static String idMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public UUIDDecoder id() {
        this.id.wrap(this.buffer, this.offset + 0);
        return this.id;
    }

    public static int streamTypeId() {
        return 2;
    }

    public static int streamTypeSinceVersion() {
        return 0;
    }

    public static String streamTypeCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String streamTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int streamTypeHeaderLength() {
        return 4;
    }

    public int streamTypeLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
    }

    public int skipStreamType() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getStreamType(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getStreamType(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapStreamType(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String streamType() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public static int metadataId() {
        return 3;
    }

    public static int metadataSinceVersion() {
        return 0;
    }

    public static String metadataCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String metadataMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int metadataHeaderLength() {
        return 4;
    }

    public int metadataLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
    }

    public int skipMetadata() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getMetadata(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getMetadata(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapMetadata(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String metadata() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        AddStreamRequestDecoder decoder = new AddStreamRequestDecoder();
        decoder.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[AddStreamRequest](sbeTemplateId=");
        builder.append(400);
        builder.append("|sbeSchemaId=");
        builder.append(2);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 2) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(2);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 16) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(16);
        builder.append("):");
        builder.append("id=");
        UUIDDecoder id = this.id();
        if (null != id) {
            id.appendTo(builder);
        } else {
            builder.append("null");
        }
        builder.append('|');
        builder.append("streamType=");
        builder.append('\'').append(this.streamType()).append('\'');
        builder.append('|');
        builder.append("metadata=");
        builder.append('\'').append(this.metadata()).append('\'');
        this.limit(originalLimit);
        return builder;
    }

    public AddStreamRequestDecoder sbeSkip() {
        this.sbeRewind();
        this.skipStreamType();
        this.skipMetadata();
        return this;
    }
}

