/* Generated SBE (Simple Binary Encoding) message codec. */
package io.camunda.zeebe.transport.stream.impl.messages;


/**
 * The unique identifier of an error
 */
@SuppressWarnings("all")
public enum ErrorCode
{
    INTERNAL((short)0),

    NOT_FOUND((short)1),

    INVALID((short)2),

    MALFORMED((short)3),

    EXHAUSTED((short)4),

    BLOCKED((short)5),

    /**
     * To be used to represent an unknown value from a later version.
     */
    SBE_UNKNOWN((short)255),

    /**
     * To be used to represent not present or null.
     */
    NULL_VAL((short)255);

    private final short value;

    ErrorCode(final short value)
    {
        this.value = value;
    }

    /**
     * The raw encoded value in the Java type representation.
     *
     * @return the raw value encoded.
     */
    public short value()
    {
        return value;
    }

    /**
     * Lookup the enum value representing the value.
     *
     * @param value encoded to be looked up.
     * @return the enum value representing the value.
     */
    public static ErrorCode get(final short value)
    {
        switch (value)
        {
            case 0: return INTERNAL;
            case 1: return NOT_FOUND;
            case 2: return INVALID;
            case 3: return MALFORMED;
            case 4: return EXHAUSTED;
            case 5: return BLOCKED;
            case 255: return NULL_VAL;
        }

        return SBE_UNKNOWN;
    }
}
