/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots.impl;

import io.camunda.zeebe.util.micrometer.ExtendedMeterDocumentation;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tags;
import java.time.Duration;

public enum SnapshotMetricsDoc implements ExtendedMeterDocumentation
{
    SNAPSHOT_COUNT{

        public String getDescription() {
            return "Total count of committed snapshots on disk";
        }

        public String getName() {
            return "zeebe.snapshot.count";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public KeyName[] getKeyNames() {
            return SnapshotMetricsDoc.getPartitionBootstrapKeyNames();
        }
    }
    ,
    SNAPSHOT_SIZE{

        public String getDescription() {
            return "Estimated snapshot size on disk";
        }

        public String getName() {
            return "zeebe.snapshot.size.bytes";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public KeyName[] getKeyNames() {
            return SnapshotMetricsDoc.getPartitionBootstrapKeyNames();
        }
    }
    ,
    SNAPSHOT_CHUNK_COUNT{

        public String getDescription() {
            return "Number of chunks in the last snapshot";
        }

        public String getName() {
            return "zeebe.snapshot.chunks.count";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public KeyName[] getKeyNames() {
            return SnapshotMetricsDoc.getPartitionBootstrapKeyNames();
        }
    }
    ,
    SNAPSHOT_DURATION{

        public String getDescription() {
            return "Approximate duration of snapshot operation";
        }

        public String getName() {
            return "zeebe.snapshot.duration";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }

        public KeyName[] getKeyNames() {
            return SnapshotMetricsDoc.getPartitionBootstrapKeyNames();
        }
    }
    ,
    SNAPSHOT_PERSIST_DURATION{

        public String getDescription() {
            return "Approximate duration of snapshot persist operation";
        }

        public String getName() {
            return "zeebe.snapshot.persist.duration";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }

        public KeyName[] getKeyNames() {
            return SnapshotMetricsDoc.getPartitionBootstrapKeyNames();
        }
    }
    ,
    SNAPSHOT_TRANSFER_DURATION{

        public String getDescription() {
            return "Total transfer duration of a snapshot between two nodes";
        }

        public String getName() {
            return "zeebe.snapshot.transfer.duration";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }

        public String getBaseUnit() {
            return "ms";
        }

        public Duration[] getTimerSLOs() {
            return new Duration[]{Duration.ofMillis(50L), Duration.ofMillis(250L), Duration.ofMillis(500L), Duration.ofSeconds(1L), Duration.ofSeconds(5L), Duration.ofSeconds(15L), Duration.ofMinutes(30L)};
        }

        public KeyName[] getKeyNames() {
            return SnapshotMetricsDoc.getPartitionBootstrapKeyNames();
        }
    }
    ,
    SNAPSHOT_FILE_SIZE{
        private static final double[] BUCKETS = new double[]{0.01, 0.1, 0.5, 1.0, 5.0, 10.0, 25.0, 50.0, 100.0, 250.0, 500.0};

        public String getDescription() {
            return "Approximate size of snapshot files";
        }

        public String getName() {
            return "zeebe.snapshot.file.size.megabytes";
        }

        public String getBaseUnit() {
            return "MB";
        }

        public Meter.Type getType() {
            return Meter.Type.DISTRIBUTION_SUMMARY;
        }

        public KeyName[] getKeyNames() {
            return SnapshotMetricsDoc.getPartitionBootstrapKeyNames();
        }

        public double[] getDistributionSLOs() {
            return BUCKETS;
        }
    };


    private static KeyName[] getPartitionBootstrapKeyNames() {
        return KeyName.merge((KeyName[][])new KeyName[][]{MicrometerUtil.PartitionKeyNames.values(), BootstrapKeyNames.values()});
    }

    public static enum BootstrapKeyNames implements KeyName
    {
        BOOTSTRAP{

            public String asString() {
                return "bootstrap";
            }
        };


        public static Tags tags(boolean bootstrap) {
            return Tags.of((String)BOOTSTRAP.asString(), (String)String.valueOf(bootstrap));
        }
    }
}

