/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots.impl;

import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.snapshots.CRC32CChecksumProvider;
import io.camunda.zeebe.snapshots.MutableChecksumsSFV;
import io.camunda.zeebe.snapshots.PersistedSnapshot;
import io.camunda.zeebe.snapshots.SnapshotException;
import io.camunda.zeebe.snapshots.SnapshotId;
import io.camunda.zeebe.snapshots.TransientSnapshot;
import io.camunda.zeebe.snapshots.impl.FileBasedSnapshotId;
import io.camunda.zeebe.snapshots.impl.FileBasedSnapshotMetadata;
import io.camunda.zeebe.snapshots.impl.FileBasedSnapshotStoreImpl;
import io.camunda.zeebe.snapshots.impl.SnapshotChecksum;
import io.camunda.zeebe.snapshots.impl.SnapshotMetrics;
import io.camunda.zeebe.util.CloseableSilently;
import io.camunda.zeebe.util.FileUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileBasedTransientSnapshot
implements TransientSnapshot {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileBasedTransientSnapshot.class);
    private final Path directory;
    private final ConcurrencyControl actor;
    private final FileBasedSnapshotStoreImpl snapshotStore;
    private final FileBasedSnapshotId snapshotId;
    private final ActorFuture<Void> takenFuture = new CompletableActorFuture();
    private boolean isValid = false;
    private PersistedSnapshot snapshot;
    private MutableChecksumsSFV checksum;
    private final CRC32CChecksumProvider checksumProvider;
    private long lastFollowupEventPosition = Long.MAX_VALUE;
    private final boolean isBootstrap;

    FileBasedTransientSnapshot(FileBasedSnapshotId snapshotId, Path directory, FileBasedSnapshotStoreImpl snapshotStore, ConcurrencyControl actor, CRC32CChecksumProvider checksumProvider, boolean isBootstrap) {
        this.snapshotId = snapshotId;
        this.snapshotStore = snapshotStore;
        this.directory = directory;
        this.actor = actor;
        this.checksumProvider = checksumProvider;
        this.isBootstrap = isBootstrap;
    }

    @Override
    public ActorFuture<Void> take(Consumer<Path> takeSnapshot) {
        this.actor.run(() -> this.takeInternal(takeSnapshot));
        return this.takenFuture;
    }

    @Override
    public TransientSnapshot withLastFollowupEventPosition(long lastFollowupEventPosition) {
        this.actor.run(() -> {
            this.lastFollowupEventPosition = lastFollowupEventPosition;
        });
        return this;
    }

    private void takeInternal(Consumer<Path> takeSnapshot) {
        block9: {
            SnapshotMetrics snapshotMetrics = this.snapshotStore.getMetrics();
            try (CloseableSilently ignored = snapshotMetrics.startTimer(this.isBootstrap);){
                try {
                    takeSnapshot.accept(this.getPath());
                    if (FileUtil.isEmpty((Path)this.directory)) {
                        this.abortInternal();
                        this.takenFuture.completeExceptionally((Throwable)new IllegalStateException(String.format("Expected to find transient snapshot in directory %s, but the directory is empty or does not exists", this.directory)));
                        break block9;
                    }
                    this.checksum = SnapshotChecksum.calculateWithProvidedChecksums(this.directory, this.checksumProvider);
                    this.snapshot = null;
                    this.isValid = true;
                    this.takenFuture.complete(null);
                }
                catch (Exception exception) {
                    LOGGER.warn("Unexpected exception on taking snapshot ({})", (Object)this.snapshotId, (Object)exception);
                    this.abortInternal();
                    this.takenFuture.completeExceptionally((Throwable)exception);
                }
            }
        }
    }

    @Override
    public ActorFuture<Void> abort() {
        CompletableActorFuture abortFuture = new CompletableActorFuture();
        this.actor.run(() -> {
            this.abortInternal();
            abortFuture.complete(null);
        });
        return abortFuture;
    }

    @Override
    public ActorFuture<PersistedSnapshot> persist() {
        CompletableActorFuture future = new CompletableActorFuture();
        this.actor.call(() -> {
            this.persistInternal((CompletableActorFuture<PersistedSnapshot>)future);
            return null;
        });
        return future;
    }

    @Override
    public SnapshotId snapshotId() {
        return this.snapshotId;
    }

    @Override
    public Path getPath() {
        return this.directory;
    }

    ActorFuture<PersistedSnapshot> persistInternal() {
        CompletableActorFuture fut = new CompletableActorFuture();
        this.persistInternal((CompletableActorFuture<PersistedSnapshot>)fut);
        return fut;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void persistInternal(CompletableActorFuture<PersistedSnapshot> future) {
        if (this.snapshot != null) {
            future.complete((Object)this.snapshot);
            return;
        }
        if (!this.takenFuture.isDone() || this.takenFuture.isCompletedExceptionally()) {
            future.completeExceptionally((Throwable)new IllegalStateException("Snapshot is not taken"));
            return;
        }
        if (!this.isValid) {
            future.completeExceptionally((Throwable)new SnapshotException.SnapshotNotFoundException("Snapshot may have been already deleted."));
            return;
        }
        try {
            FileBasedSnapshotMetadata metadata = this.isBootstrap ? FileBasedSnapshotMetadata.forBootstrap(1) : new FileBasedSnapshotMetadata(1, this.snapshotId.getProcessedPosition(), this.snapshotId.getExportedPosition(), this.lastFollowupEventPosition);
            this.writeMetadataAndUpdateChecksum(metadata);
            FileBasedSnapshotId idWithChecksum = new FileBasedSnapshotId(this.snapshotId.getIndex(), this.snapshotId.getTerm(), this.snapshotId.getProcessedPosition(), this.snapshotId.getExportedPosition(), this.snapshotId.getBrokerId(), Long.toHexString(this.checksum.getCombinedChecksum()));
            Path directoryWithChecksum = this.directory.getParent().resolve(idWithChecksum.getSnapshotIdAsString());
            try {
                FileUtil.moveDurably((Path)this.directory, (Path)directoryWithChecksum, (CopyOption[])new CopyOption[]{StandardCopyOption.ATOMIC_MOVE});
            }
            catch (Exception e) {
                if (e instanceof FileSystemException) {
                    FileSystemException ignored = (FileSystemException)e;
                    if (Files.exists(directoryWithChecksum, new LinkOption[0])) {
                        future.completeExceptionally((Throwable)new SnapshotException.SnapshotAlreadyExistsException("Snapshot %s already exists".formatted(idWithChecksum)));
                        return;
                    }
                }
                future.completeExceptionally((Throwable)new SnapshotException("Unable to move snapshot %s to target directory with checksum %s".formatted(idWithChecksum, directoryWithChecksum), e));
                return;
            }
            this.snapshot = this.snapshotStore.persistNewSnapshot(directoryWithChecksum, idWithChecksum, this.checksum, metadata);
            future.complete((Object)this.snapshot);
        }
        catch (Exception e) {
            future.completeExceptionally((Throwable)e);
        }
        this.snapshotStore.removePendingSnapshot(this);
    }

    private void writeMetadataAndUpdateChecksum(FileBasedSnapshotMetadata metadata) throws IOException {
        Path metadataPath = this.directory.resolve("zeebe.metadata");
        try (FileChannel channel = FileChannel.open(metadataPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.DSYNC);
             OutputStream output = Channels.newOutputStream(channel);){
            metadata.encode(output);
            this.checksum.updateFromFile(metadataPath);
        }
    }

    private void abortInternal() {
        try {
            this.isValid = false;
            this.snapshot = null;
            LOGGER.debug("Aborting transient snapshot {}", (Object)this);
            FileUtil.deleteFolderIfExists((Path)this.directory);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to delete pending snapshot {}", (Object)this, (Object)e);
        }
        finally {
            this.snapshotStore.removePendingSnapshot(this);
        }
    }

    public String toString() {
        return "FileBasedTransientSnapshot{directory=" + String.valueOf(this.directory) + ", snapshotId=" + String.valueOf(this.snapshotId) + ", checksum=" + String.valueOf(this.checksum == null ? "none" : Long.valueOf(this.checksum.getCombinedChecksum())) + "}";
    }
}

