/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.stream.Stream;

public final class SnapshotCopyUtil {
    public static void copyAllFiles(Path source, Path target) {
        try (Stream<Path> stream = Files.walk(source, new FileVisitOption[0]);){
            stream.forEach(path -> {
                if (!source.equals(path)) {
                    try {
                        Path relativePath = source.relativize((Path)path);
                        Path targetPath = target.resolve(relativePath);
                        Files.copy(path, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

