/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots;

import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.snapshots.ImmutableChecksumsSFV;
import io.camunda.zeebe.snapshots.SnapshotChunkReader;
import io.camunda.zeebe.snapshots.SnapshotId;
import io.camunda.zeebe.snapshots.SnapshotMetadata;
import io.camunda.zeebe.snapshots.SnapshotReservation;
import io.camunda.zeebe.util.VisibleForTesting;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public interface PersistedSnapshot {
    public int version();

    public SnapshotId snapshotId();

    public long getIndex();

    public long getTerm();

    public SnapshotChunkReader newChunkReader();

    public Path getPath();

    public Path getChecksumPath();

    public long getCompactionBound();

    public String getId();

    public ImmutableChecksumsSFV getChecksums();

    public SnapshotMetadata getMetadata();

    public ActorFuture<SnapshotReservation> reserve();

    default public boolean isBootstrap() {
        return this.getMetadata() != null && this.getMetadata().isBootstrap();
    }

    @VisibleForTesting
    public boolean isReserved();

    default public Map<String, Path> files() {
        HashMap<String, Path> map = new HashMap<String, Path>();
        try (Stream<Path> stream = Files.list(this.getPath());){
            stream.forEach(file -> {
                String fileName = file.getFileName().toString();
                map.put(fileName, (Path)file);
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        map.put(this.getChecksumPath().getFileName().toString(), this.getChecksumPath());
        return map;
    }
}

