/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots.impl;

import io.camunda.zeebe.snapshots.impl.FileBasedSnapshotMetadata;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileBasedSnapshotMetadataTest {
    @Test
    public void shouldDeserializeMetadataFromPreviousVersion() throws IOException {
        String previousMetadata = "{\"version\":1,\"processedPosition\":71662471,\"exportedPosition\":74709149,\"lastFollowupEventPosition\":74708149}\n";
        FileBasedSnapshotMetadata deserialized = FileBasedSnapshotMetadata.decode((byte[])"{\"version\":1,\"processedPosition\":71662471,\"exportedPosition\":74709149,\"lastFollowupEventPosition\":74708149}\n".getBytes());
        Assertions.assertThat((boolean)deserialized.isBootstrap()).isFalse();
        Assertions.assertThat((int)deserialized.version()).isOne();
        Assertions.assertThat((long)deserialized.exportedPosition()).isEqualTo(74709149L);
        Assertions.assertThat((long)deserialized.processedPosition()).isEqualTo(71662471L);
        Assertions.assertThat((long)deserialized.lastFollowupEventPosition()).isEqualTo(74708149L);
    }

    @Test
    void shouldSerializeDeserialize() throws IOException {
        FileBasedSnapshotMetadata metadata = new FileBasedSnapshotMetadata(1, 100L, 200L, 300L, true);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        metadata.encode((OutputStream)bos);
        FileBasedSnapshotMetadata deserialized = FileBasedSnapshotMetadata.decode((byte[])bos.toByteArray());
        Assertions.assertThat((Object)deserialized).isEqualTo((Object)metadata);
    }
}

