/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots;

import io.camunda.zeebe.snapshots.SnapshotChunk;

public final class SnapshotChunkWrapper
implements SnapshotChunk {
    private final SnapshotChunk wrappedChunk;
    private String snapshotId;
    private Integer totalCount;
    private Long checksum;
    private byte[] contents;

    private SnapshotChunkWrapper(SnapshotChunk wrappedChunk) {
        this.wrappedChunk = wrappedChunk;
    }

    public static SnapshotChunk withSnapshotId(SnapshotChunk wrappedChunk, String snapshotId) {
        SnapshotChunkWrapper wrapper = new SnapshotChunkWrapper(wrappedChunk);
        wrapper.snapshotId = snapshotId;
        return wrapper;
    }

    public static SnapshotChunk withTotalCount(SnapshotChunk wrappedChunk, Integer totalCount) {
        SnapshotChunkWrapper wrapper = new SnapshotChunkWrapper(wrappedChunk);
        wrapper.totalCount = totalCount;
        return wrapper;
    }

    public static SnapshotChunk withChecksum(SnapshotChunk wrappedChunk, Long checksum) {
        SnapshotChunkWrapper wrapper = new SnapshotChunkWrapper(wrappedChunk);
        wrapper.checksum = checksum;
        return wrapper;
    }

    public static SnapshotChunk withContents(SnapshotChunk wrappedChunk, byte[] contents) {
        SnapshotChunkWrapper wrapper = new SnapshotChunkWrapper(wrappedChunk);
        wrapper.contents = contents;
        return wrapper;
    }

    public String getSnapshotId() {
        if (this.snapshotId == null) {
            return this.wrappedChunk.getSnapshotId();
        }
        return this.snapshotId;
    }

    public int getTotalCount() {
        if (this.totalCount == null) {
            return this.wrappedChunk.getTotalCount();
        }
        return this.totalCount;
    }

    public String getChunkName() {
        return this.wrappedChunk.getChunkName();
    }

    public long getChecksum() {
        if (this.checksum == null) {
            return this.wrappedChunk.getChecksum();
        }
        return this.checksum;
    }

    public byte[] getContent() {
        if (this.contents == null) {
            return this.wrappedChunk.getContent();
        }
        return this.contents;
    }

    public long getFileBlockPosition() {
        return this.wrappedChunk.getFileBlockPosition();
    }

    public long getTotalFileSize() {
        return this.wrappedChunk.getTotalFileSize();
    }
}

