/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots.impl;

import io.camunda.zeebe.snapshots.impl.FileBasedSnapshotId;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

final class FileBasedSnapshotIdTest {
    FileBasedSnapshotIdTest() {
    }

    @Test
    void canParseIdWithoutChecksum() {
        String id = "1-2-3-4-5";
        FileBasedSnapshotId snapshotId = FileBasedSnapshotId.ofFileName((String)"1-2-3-4-5").getOrThrow();
        Assertions.assertThat((long)snapshotId.getIndex()).isEqualTo(1L);
        Assertions.assertThat((long)snapshotId.getTerm()).isEqualTo(2L);
        Assertions.assertThat((long)snapshotId.getProcessedPosition()).isEqualTo(3L);
        Assertions.assertThat((long)snapshotId.getExportedPosition()).isEqualTo(4L);
    }

    @Test
    void canRoundTripWithoutChecksum() {
        String originalId = "1-2-3-4-5";
        FileBasedSnapshotId parsedId = FileBasedSnapshotId.ofFileName((String)"1-2-3-4-5").getOrThrow();
        Assertions.assertThat((String)parsedId.getSnapshotIdAsString()).isEqualTo("1-2-3-4-5");
    }

    @Test
    void canParseIdWithChecksum() {
        String id = "1-2-3-4-5-somechecksum";
        FileBasedSnapshotId snapshotId = FileBasedSnapshotId.ofFileName((String)"1-2-3-4-5-somechecksum").getOrThrow();
        Assertions.assertThat((long)snapshotId.getIndex()).isEqualTo(1L);
        Assertions.assertThat((long)snapshotId.getTerm()).isEqualTo(2L);
        Assertions.assertThat((long)snapshotId.getProcessedPosition()).isEqualTo(3L);
        Assertions.assertThat((long)snapshotId.getExportedPosition()).isEqualTo(4L);
    }

    @Test
    void canRoundTripWithChecksum() {
        String originalId = "1-2-3-4-5-somechecksum";
        FileBasedSnapshotId parsedId = FileBasedSnapshotId.ofFileName((String)"1-2-3-4-5-somechecksum").getOrThrow();
        Assertions.assertThat((String)parsedId.getSnapshotIdAsString()).isEqualTo("1-2-3-4-5-somechecksum");
    }
}

