/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots;

import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.testing.ActorSchedulerRule;
import io.camunda.zeebe.snapshots.PersistedSnapshot;
import io.camunda.zeebe.snapshots.TransientSnapshot;
import io.camunda.zeebe.snapshots.impl.FileBasedReceivedSnapshot;
import io.camunda.zeebe.snapshots.impl.FileBasedSnapshotStore;
import io.camunda.zeebe.util.FileUtil;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class PersistedSnapshotStoreTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ActorSchedulerRule scheduler = new ActorSchedulerRule();
    private FileBasedSnapshotStore persistedSnapshotStore;

    @Before
    public void before() {
        boolean partitionId = true;
        File root = this.temporaryFolder.getRoot();
        FileBasedSnapshotStore snapshotStore = new FileBasedSnapshotStore(0, 1, root.toPath(), snapshotPath -> Map.of(), (MeterRegistry)new SimpleMeterRegistry());
        this.scheduler.submitActor((Actor)snapshotStore).join();
        this.persistedSnapshotStore = snapshotStore;
    }

    @Test
    public void shouldReturnZeroWhenNoSnapshotWasTaken() {
        long currentSnapshotIndex = this.persistedSnapshotStore.getCurrentSnapshotIndex();
        Assertions.assertThat((long)currentSnapshotIndex).isZero();
    }

    @Test
    public void shouldReturnEmptyWhenNoSnapshotWasTaken() {
        Optional optionalLatestSnapshot = this.persistedSnapshotStore.getLatestSnapshot();
        Assertions.assertThat((Optional)optionalLatestSnapshot).isEmpty();
    }

    @Test
    public void shouldReturnFalseOnNonExistingSnapshot() {
        boolean exists = this.persistedSnapshotStore.hasSnapshotId("notexisting");
        Assertions.assertThat((boolean)exists).isFalse();
    }

    @Test
    public void shouldTakeReceivedSnapshot() {
        long index = 1L;
        FileBasedReceivedSnapshot transientSnapshot = (FileBasedReceivedSnapshot)this.persistedSnapshotStore.newReceivedSnapshot("1-0-123-121-1").join();
        Assertions.assertThat((long)transientSnapshot.index()).isEqualTo(1L);
    }

    @Test
    public void shouldListAllFiles() {
        TransientSnapshot transientSnapshot = (TransientSnapshot)this.persistedSnapshotStore.newTransientSnapshot(1L, 0L, 123L, 121L, false).get();
        List<String> snapshotFileNames = List.of("zeebe.metadata", "table-0.sst", "table-1.sst", "table-2.sst");
        transientSnapshot.take(path -> {
            try {
                FileUtil.ensureDirectoryExists((Path)path);
                for (String filename : snapshotFileNames) {
                    File file = new File(path.toString(), filename);
                    file.createNewFile();
                    try (FileOutputStream fos = new FileOutputStream(file);){
                        fos.write("test".getBytes());
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).join();
        PersistedSnapshot persistedSnapshot = (PersistedSnapshot)transientSnapshot.persist().join();
        Map files = persistedSnapshot.files();
        HashMap<String, Path> expectedFiles = new HashMap<String, Path>(snapshotFileNames.stream().collect(Collectors.toMap(f -> f, f -> persistedSnapshot.getPath().resolve((String)f))));
        expectedFiles.put(persistedSnapshot.getChecksumPath().getFileName().toString(), persistedSnapshot.getChecksumPath());
        Assertions.assertThat((Map)files).containsExactlyInAnyOrderEntriesOf(expectedFiles);
    }
}

