/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots.impl;

import io.camunda.zeebe.snapshots.impl.SnapshotMetricsDoc;
import io.camunda.zeebe.util.CloseableSilently;
import io.camunda.zeebe.util.collection.MArray;
import io.camunda.zeebe.util.micrometer.ExtendedMeterDocumentation;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public final class SnapshotMetrics {
    private final MArray<AtomicLong> snapshotChunkCountArray = MArray.of(AtomicLong[]::new, (int[])new int[]{2});
    private final MArray<AtomicLong> snapshotSizeArray = MArray.of(AtomicLong[]::new, (int[])new int[]{2});
    private final Clock clock;
    private final MArray<Timer> snapshotPersistDuration = MArray.of(Timer[]::new, (int[])new int[]{2});
    private final MArray<DistributionSummary> snapshotFileSize = MArray.of(DistributionSummary[]::new, (int[])new int[]{2});
    private final MArray<Timer> snapshotDuration = MArray.of(Timer[]::new, (int[])new int[]{2});
    private final MArray<Counter> snapshotCount = MArray.of(Counter[]::new, (int[])new int[]{2});
    private final MArray<Timer> snapshotTransferDuration = MArray.of(Timer[]::new, (int[])new int[]{2});

    public SnapshotMetrics(MeterRegistry registry) {
        this.clock = registry.config().clock();
        for (Boolean isBootstrap : List.of(Boolean.valueOf(true), Boolean.valueOf(false))) {
            int index = SnapshotMetrics.encodeBoolean(isBootstrap);
            this.snapshotChunkCountArray.put((Object)new AtomicLong(), new int[]{index});
            this.snapshotSizeArray.put((Object)new AtomicLong(), new int[]{index});
            this.snapshotDuration.put((Object)MicrometerUtil.buildTimer((ExtendedMeterDocumentation)SnapshotMetricsDoc.SNAPSHOT_DURATION).tags((Iterable)SnapshotMetricsDoc.BootstrapKeyNames.tags(isBootstrap)).register(registry), new int[]{index});
            this.snapshotPersistDuration.put((Object)MicrometerUtil.buildTimer((ExtendedMeterDocumentation)SnapshotMetricsDoc.SNAPSHOT_PERSIST_DURATION).tags((Iterable)SnapshotMetricsDoc.BootstrapKeyNames.tags(isBootstrap)).register(registry), new int[]{index});
            this.snapshotTransferDuration.put((Object)MicrometerUtil.buildTimer((ExtendedMeterDocumentation)SnapshotMetricsDoc.SNAPSHOT_TRANSFER_DURATION).tags((Iterable)SnapshotMetricsDoc.BootstrapKeyNames.tags(isBootstrap)).register(registry), new int[]{index});
            this.snapshotFileSize.put((Object)MicrometerUtil.buildSummary((ExtendedMeterDocumentation)SnapshotMetricsDoc.SNAPSHOT_FILE_SIZE).tags((Iterable)SnapshotMetricsDoc.BootstrapKeyNames.tags(isBootstrap)).register(registry), new int[]{index});
            this.snapshotCount.put((Object)Counter.builder((String)SnapshotMetricsDoc.SNAPSHOT_COUNT.getName()).description(SnapshotMetricsDoc.SNAPSHOT_COUNT.getDescription()).tags((Iterable)SnapshotMetricsDoc.BootstrapKeyNames.tags(isBootstrap)).register(registry), new int[]{index});
            Gauge.builder((String)SnapshotMetricsDoc.SNAPSHOT_CHUNK_COUNT.getName(), (Object)((AtomicLong)this.snapshotChunkCountArray.get(new int[]{index})), Number::longValue).description(SnapshotMetricsDoc.SNAPSHOT_CHUNK_COUNT.getDescription()).tags((Iterable)SnapshotMetricsDoc.BootstrapKeyNames.tags(isBootstrap)).register(registry);
            Gauge.builder((String)SnapshotMetricsDoc.SNAPSHOT_SIZE.getName(), (Object)((AtomicLong)this.snapshotSizeArray.get(new int[]{index})), Number::longValue).description(SnapshotMetricsDoc.SNAPSHOT_SIZE.getDescription()).tags((Iterable)SnapshotMetricsDoc.BootstrapKeyNames.tags(isBootstrap)).register(registry);
        }
    }

    void incrementSnapshotCount(boolean isBootstrap) {
        ((Counter)this.snapshotCount.get(new int[]{SnapshotMetrics.encodeBoolean(isBootstrap)})).increment();
    }

    void observeSnapshotSize(long sizeInBytes, boolean isBootstrap) {
        ((AtomicLong)this.snapshotSizeArray.get(new int[]{SnapshotMetrics.encodeBoolean(isBootstrap)})).set(sizeInBytes);
    }

    void observeSnapshotChunkCount(long count, boolean isBootstrap) {
        ((AtomicLong)this.snapshotChunkCountArray.get(new int[]{SnapshotMetrics.encodeBoolean(isBootstrap)})).set(count);
    }

    void observeSnapshotFileSize(long sizeInBytes, boolean isBootstrap) {
        ((DistributionSummary)this.snapshotFileSize.get(new int[]{SnapshotMetrics.encodeBoolean(isBootstrap)})).record((double)((float)sizeInBytes / 1000000.0f));
    }

    CloseableSilently startTimer(boolean isBootstrap) {
        return MicrometerUtil.timer((Timer)((Timer)this.snapshotDuration.get(new int[]{SnapshotMetrics.encodeBoolean(isBootstrap)})), (Timer.Sample)Timer.start((Clock)this.clock));
    }

    CloseableSilently startPersistTimer(boolean isBootstrap) {
        return MicrometerUtil.timer((Timer)((Timer)this.snapshotPersistDuration.get(new int[]{SnapshotMetrics.encodeBoolean(isBootstrap)})), (Timer.Sample)Timer.start((Clock)this.clock));
    }

    public CloseableSilently startTransferTimer(boolean isBootstrap) {
        return MicrometerUtil.timer((Timer)((Timer)this.snapshotTransferDuration.get(new int[]{SnapshotMetrics.encodeBoolean(isBootstrap)})), (Timer.Sample)Timer.start((Clock)this.clock));
    }

    public Timer getTransferDuration(boolean isBootstrap) {
        return (Timer)this.snapshotTransferDuration.get(new int[]{SnapshotMetrics.encodeBoolean(isBootstrap)});
    }

    private static boolean decodeBoolean(int i) {
        return i == 1;
    }

    private static int encodeBoolean(boolean b) {
        return b ? 1 : 0;
    }
}

