/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots.impl;

import io.camunda.zeebe.snapshots.ImmutableChecksumsSFV;
import io.camunda.zeebe.snapshots.MutableChecksumsSFV;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32C;

public final class SfvChecksumImpl
implements MutableChecksumsSFV {
    private static final String SFV_HEADER = "; This is an SFC checksum file for all files in the given directory.\n; You might use cksfv or another tool to validate these files manually.\n; This is an automatically created file - please do NOT modify.\n";
    private static final String FORMAT_SNAPSHOT_DIRECTORY_LINE = "; snapshot directory = %s\n";
    private static final String FORMAT_FILE_CRC_LINE = "%s   %s\n";
    private static final String FILE_CRC_SEPARATOR_REGEX = " {3}";
    private static final Pattern FILE_CRC_PATTERN = Pattern.compile("(.*) {3}([0-9a-fA-F]{1,16})");
    private final SortedMap<String, Long> checksums = new TreeMap<String, Long>();
    private String snapshotDirectoryComment;

    @Override
    public void write(OutputStream stream) throws IOException {
        PrintWriter writer = new PrintWriter(stream);
        writer.print(SFV_HEADER);
        if (this.snapshotDirectoryComment != null) {
            writer.printf(FORMAT_SNAPSHOT_DIRECTORY_LINE, this.snapshotDirectoryComment);
        }
        for (Map.Entry<String, Long> entry : this.checksums.entrySet()) {
            writer.printf(FORMAT_FILE_CRC_LINE, entry.getKey(), Long.toHexString(entry.getValue()));
        }
        writer.flush();
        if (writer.checkError()) {
            throw new IOException("Expected to write the SFV Checksum, but failed during writing.");
        }
    }

    @Override
    public SortedMap<String, Long> getChecksums() {
        return this.checksums;
    }

    @Override
    public boolean sameChecksums(ImmutableChecksumsSFV o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        return Objects.equals(this.checksums, o.getChecksums());
    }

    @Override
    public long getCombinedChecksum() {
        CRC32C combinedChecksum = new CRC32C();
        for (Map.Entry<String, Long> entry : this.checksums.entrySet()) {
            combinedChecksum.update(entry.getKey().getBytes(StandardCharsets.UTF_8));
            int upper = (int)(entry.getValue() >> 32);
            int lower = (int)entry.getValue().longValue();
            combinedChecksum.update(upper);
            combinedChecksum.update(lower);
        }
        return combinedChecksum.getValue();
    }

    public String toString() {
        return "SfvChecksumImpl{, checksums=" + String.valueOf(this.checksums) + "}";
    }

    public void setSnapshotDirectoryComment(String headerComment) {
        this.snapshotDirectoryComment = headerComment;
    }

    @Override
    public void updateFromFile(Path filePath) throws IOException {
        String fileName = filePath.getFileName().toString();
        CRC32C checksum = new CRC32C();
        ByteBuffer readBuffer = ByteBuffer.allocate(4096);
        try (FileChannel channel = FileChannel.open(filePath, StandardOpenOption.READ);){
            readBuffer.clear();
            while (channel.read(readBuffer) > 0) {
                readBuffer.flip();
                checksum.update(readBuffer);
                readBuffer.clear();
            }
        }
        this.checksums.put(fileName, checksum.getValue());
    }

    @Override
    public void updateFromBytes(String fileName, byte[] bytes) {
        CRC32C checksum = new CRC32C();
        checksum.update(bytes);
        this.checksums.put(fileName, checksum.getValue());
    }

    @Override
    public void updateFromSfvFile(String ... lines) {
        for (String line : lines) {
            Matcher matcher;
            if ((line = line.trim()).startsWith(";") || !(matcher = FILE_CRC_PATTERN.matcher(line)).find()) continue;
            Long crc = Long.parseLong(matcher.group(2), 16);
            String fileName = matcher.group(1).trim();
            this.checksums.put(fileName, crc);
        }
    }

    @Override
    public void updateFromChecksum(Path filePath, long checksum) {
        String fileName = filePath.getFileName().toString();
        this.checksums.put(fileName, checksum);
    }
}

