/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots.impl;

import io.camunda.zeebe.snapshots.SnapshotId;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;

public final class FileBasedSnapshotId
implements SnapshotId {
    private static final int SNAPSHOT_ID_PARTS = 6;
    private static final int PREV_SNAPSHOT_ID_PARTS = 5;
    private final long index;
    private final long term;
    private final long processedPosition;
    private final long exporterPosition;
    private final int brokerId;
    private final Optional<String> checksum;

    FileBasedSnapshotId(long index, long term, long processedPosition, long exporterPosition, int brokerId) {
        this.index = index;
        this.term = term;
        this.processedPosition = processedPosition;
        this.exporterPosition = exporterPosition;
        this.brokerId = brokerId;
        this.checksum = Optional.empty();
    }

    FileBasedSnapshotId(long index, long term, long processedPosition, long exporterPosition, int brokerId, String checksum) {
        this.index = index;
        this.term = term;
        this.processedPosition = processedPosition;
        this.exporterPosition = exporterPosition;
        this.brokerId = brokerId;
        this.checksum = Optional.of(checksum);
    }

    static FileBasedSnapshotId forBoostrap(int brokerId) {
        return new FileBasedSnapshotId(1L, 1L, 0L, 0L, brokerId);
    }

    public static SnapshotParseResult ofPath(Path path) {
        return FileBasedSnapshotId.ofFileName(path.getFileName().toString());
    }

    public static SnapshotParseResult ofFileName(String name) {
        String[] parts = name.split("-");
        if (parts.length >= 6) {
            try {
                long index = Long.parseLong(parts[0]);
                long term = Long.parseLong(parts[1]);
                long processedPosition = Long.parseLong(parts[2]);
                long exporterPosition = Long.parseLong(parts[3]);
                int brokerId = Integer.parseInt(parts[4]);
                String checksum = parts[5];
                return new SnapshotParseResult.Parsed(new FileBasedSnapshotId(index, term, processedPosition, exporterPosition, brokerId, checksum));
            }
            catch (NumberFormatException e) {
                return new SnapshotParseResult.Invalid(new IllegalArgumentException("Failed to parse part of snapshot id", e));
            }
        }
        if (parts.length == 5) {
            try {
                long index = Long.parseLong(parts[0]);
                long term = Long.parseLong(parts[1]);
                long processedPosition = Long.parseLong(parts[2]);
                long exporterPosition = Long.parseLong(parts[3]);
                int brokerId = Integer.parseInt(parts[4]);
                return new SnapshotParseResult.Parsed(new FileBasedSnapshotId(index, term, processedPosition, exporterPosition, brokerId));
            }
            catch (NumberFormatException e) {
                return new SnapshotParseResult.Invalid(new IllegalArgumentException("Failed to parse part of snapshot id", e));
            }
        }
        return new SnapshotParseResult.Invalid(new IllegalArgumentException("Expected snapshot file format to be %%d-%%d-%%d-%%d-%%d-%%s, but was %s".formatted(name)));
    }

    @Override
    public long getIndex() {
        return this.index;
    }

    @Override
    public long getTerm() {
        return this.term;
    }

    @Override
    public long getProcessedPosition() {
        return this.processedPosition;
    }

    @Override
    public long getExportedPosition() {
        return this.exporterPosition;
    }

    @Override
    public String getSnapshotIdAsString() {
        if (this.checksum.isPresent()) {
            return String.format("%d-%d-%d-%d-%d-%s", this.getIndex(), this.getTerm(), this.getProcessedPosition(), this.getExportedPosition(), this.brokerId, this.checksum.get());
        }
        return String.format("%d-%d-%d-%d-%d", this.getIndex(), this.getTerm(), this.getProcessedPosition(), this.getExportedPosition(), this.brokerId);
    }

    public int getBrokerId() {
        return this.brokerId;
    }

    public int hashCode() {
        return Objects.hash(this.index, this.term, this.processedPosition, this.exporterPosition, this.brokerId, this.checksum.hashCode());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileBasedSnapshotId that = (FileBasedSnapshotId)o;
        return this.index == that.index && this.term == that.term && this.processedPosition == that.processedPosition && this.exporterPosition == that.exporterPosition && this.brokerId == that.brokerId && this.checksum.equals(that.checksum);
    }

    public String toString() {
        return "FileBasedSnapshotId{index=" + this.index + ", term=" + this.term + ", processedPosition=" + this.processedPosition + ", exporterPosition=" + this.exporterPosition + ", brokerId=" + this.brokerId + ", checksum=" + String.valueOf(this.checksum) + "}";
    }

    public static sealed interface SnapshotParseResult {
        public FileBasedSnapshotId getOrThrow();

        public record Invalid(Exception exception) implements SnapshotParseResult
        {
            @Override
            public FileBasedSnapshotId getOrThrow() {
                throw new IllegalStateException("Snapshot id could not be parsed", this.exception);
            }
        }

        public record Parsed(FileBasedSnapshotId snapshotId) implements SnapshotParseResult
        {
            @Override
            public FileBasedSnapshotId getOrThrow() {
                return this.snapshotId;
            }
        }
    }
}

