/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots.transfer;

import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.scheduler.testing.ControlledActorSchedulerExtension;
import io.camunda.zeebe.snapshots.ConstructableSnapshotStore;
import io.camunda.zeebe.snapshots.PersistedSnapshot;
import io.camunda.zeebe.snapshots.PersistedSnapshotStore;
import io.camunda.zeebe.snapshots.ReceivableSnapshotStore;
import io.camunda.zeebe.snapshots.SnapshotCopyUtil;
import io.camunda.zeebe.snapshots.SnapshotTransferUtil;
import io.camunda.zeebe.snapshots.impl.FileBasedSnapshotMetadata;
import io.camunda.zeebe.snapshots.impl.FileBasedSnapshotStore;
import io.camunda.zeebe.snapshots.impl.SnapshotMetrics;
import io.camunda.zeebe.snapshots.transfer.SnapshotTransferImpl;
import io.camunda.zeebe.snapshots.transfer.SnapshotTransferService;
import io.camunda.zeebe.snapshots.transfer.SnapshotTransferServiceImpl;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.AutoClose;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class SnapshotTransferTest {
    @RegisterExtension
    public final ControlledActorSchedulerExtension actorScheduler = new ControlledActorSchedulerExtension();
    @TempDir
    Path temporaryFolder;
    FileBasedSnapshotStore senderSnapshotStore;
    FileBasedSnapshotStore receiverSnapshotStore;
    private SnapshotTransferImpl snapshotTransfer;
    private SnapshotTransferService.TakeSnapshot takeSnapshotMock;
    @AutoClose
    private MeterRegistry meterRegistry = new SimpleMeterRegistry();
    private final SnapshotMetrics snapshotMetrics = new SnapshotMetrics(this.meterRegistry);

    @BeforeEach
    public void beforeEach() throws Exception {
        boolean partitionId = true;
        Path senderDirectory = this.temporaryFolder.resolve("sender");
        Path receiverDirectory = this.temporaryFolder.resolve("receiver");
        this.senderSnapshotStore = new FileBasedSnapshotStore(0, 1, senderDirectory, snapshotPath -> Map.of(), (MeterRegistry)new SimpleMeterRegistry());
        this.actorScheduler.submitActor((Actor)this.senderSnapshotStore);
        this.actorScheduler.workUntilDone();
        this.receiverSnapshotStore = new FileBasedSnapshotStore(0, 1, receiverDirectory, snapshotPath -> Map.of(), (MeterRegistry)new SimpleMeterRegistry());
        this.actorScheduler.submitActor((Actor)this.receiverSnapshotStore);
        this.actorScheduler.workUntilDone();
        this.takeSnapshotMock = (SnapshotTransferService.TakeSnapshot)Mockito.mock(SnapshotTransferService.TakeSnapshot.class);
        this.snapshotTransfer = new SnapshotTransferImpl(control -> (SnapshotTransferService)Mockito.spy((Object)new SnapshotTransferServiceImpl((PersistedSnapshotStore)this.senderSnapshotStore, this.takeSnapshotMock, 1, SnapshotCopyUtil::copyAllFiles, control)), this.snapshotMetrics, (ReceivableSnapshotStore)this.receiverSnapshotStore);
        this.actorScheduler.submitActor((Actor)this.snapshotTransfer);
        this.actorScheduler.workUntilDone();
        this.actorScheduler.workUntilDone();
    }

    @Test
    public void shouldTransferSnapshot() {
        boolean partitionId = true;
        ActorFuture<PersistedSnapshot> takeSnapshotFuture = SnapshotTransferUtil.takePersistedSnapshot((ConstructableSnapshotStore)this.senderSnapshotStore, SnapshotTransferUtil.SNAPSHOT_FILE_CONTENTS, (ConcurrencyControl)this.receiverSnapshotStore);
        this.actorScheduler.workUntilDone();
        Assertions.assertThat(takeSnapshotFuture).succeedsWithin(Duration.ofSeconds(3L));
        ActorFuture persistedSnapshotFuture = this.snapshotTransfer.getLatestSnapshot(1);
        this.actorScheduler.workUntilDone();
        Assertions.assertThat((Future)persistedSnapshotFuture).succeedsWithin(Duration.ofSeconds(30L)).satisfies(new ThrowingConsumer[]{snapshot -> {
            Assertions.assertThat((String)snapshot.getId()).startsWith((CharSequence)"1-1-0-0-0-");
            Assertions.assertThat((Object)snapshot.getMetadata()).isEqualTo((Object)FileBasedSnapshotMetadata.forBootstrap((int)1));
            Assertions.assertThat((boolean)snapshot.isBootstrap()).isTrue();
            Assertions.assertThat((Map)snapshot.files()).isNotEmpty();
        }});
        Assertions.assertThat((double)this.snapshotMetrics.getTransferDuration(true).mean(TimeUnit.MILLISECONDS)).isGreaterThan(0.1);
        ((SnapshotTransferServiceImpl)Mockito.verify((Object)((SnapshotTransferServiceImpl)this.snapshotTransfer.snapshotTransferService()))).withReservation((PersistedSnapshot)ArgumentMatchers.any(), (Supplier)ArgumentMatchers.any());
    }

    @Test
    public void shouldTakeSnapshotIfNoneIsPresent() {
        boolean partitionId = true;
        Mockito.when((Object)this.takeSnapshotMock.takeSnapshot(ArgumentMatchers.anyLong())).thenReturn((Object)CompletableActorFuture.completed(null));
        ActorFuture persistedSnapshotFuture = this.snapshotTransfer.getLatestSnapshot(1);
        ((SnapshotTransferService.TakeSnapshot)Mockito.verify((Object)this.takeSnapshotMock, (VerificationMode)Mockito.timeout((long)5000L))).takeSnapshot(ArgumentMatchers.eq((long)-1L));
    }
}

