/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots.impl;

import io.camunda.zeebe.snapshots.impl.SfvChecksumImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class SfvChecksumTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private SfvChecksumImpl sfvChecksum;

    @Before
    public void setUp() throws Exception {
        this.sfvChecksum = new SfvChecksumImpl();
    }

    @Test
    public void shouldReadAndWriteSameValues() throws IOException {
        String[] givenSfvLines = new String[]{"file1   aabbccdd"};
        this.sfvChecksum.updateFromSfvFile(givenSfvLines);
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
        this.sfvChecksum.write((OutputStream)arrayOutputStream);
        String serialized = arrayOutputStream.toString(StandardCharsets.UTF_8);
        Object[] actualSfVlines = serialized.split(System.lineSeparator());
        Assertions.assertThat((Object[])actualSfVlines).contains((Object[])new String[]{givenSfvLines[0]});
    }

    @Test
    public void shouldThrowExceptionOnWriteWhenFlushFails() throws IOException {
        String[] givenSfvLines = new String[]{"file1   aabbccdd"};
        this.sfvChecksum.updateFromSfvFile(givenSfvLines);
        try (FailingFlushOutputStream failingStream = new FailingFlushOutputStream();){
            Assertions.assertThatThrownBy(() -> this.sfvChecksum.write((OutputStream)failingStream)).isInstanceOf(IOException.class);
        }
    }

    @Test
    public void shouldThrowExceptionOnWriteWhenWriteFails() throws IOException {
        String[] givenSfvLines = new String[]{"file1   aabbccdd"};
        this.sfvChecksum.updateFromSfvFile(givenSfvLines);
        try (FailingWriteOutputStream failingStream = new FailingWriteOutputStream();){
            Assertions.assertThatThrownBy(() -> this.sfvChecksum.write((OutputStream)failingStream)).isInstanceOf(IOException.class);
        }
    }

    @Test
    public void shouldWriteSnapshotDirectoryCommentIfPresent() throws IOException {
        this.sfvChecksum.setSnapshotDirectoryComment("/foo/bar");
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
        this.sfvChecksum.write((OutputStream)arrayOutputStream);
        String serialized = arrayOutputStream.toString(StandardCharsets.UTF_8);
        Assertions.assertThat((String)serialized).contains(new CharSequence[]{"; snapshot directory = /foo/bar"});
    }

    @Test
    public void shouldContainHumanReadableInstructions() throws IOException {
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
        this.sfvChecksum.write((OutputStream)arrayOutputStream);
        String serialized = arrayOutputStream.toString(StandardCharsets.UTF_8);
        Assertions.assertThat((String)serialized).contains(new CharSequence[]{"; This is an SFC checksum file for all files in the given directory."});
        Assertions.assertThat((String)serialized).contains(new CharSequence[]{"; You might use cksfv or another tool to validate these files manually."});
        Assertions.assertThat((String)serialized).contains(new CharSequence[]{"; This is an automatically created file - please do NOT modify."});
    }

    private static final class FailingFlushOutputStream
    extends OutputStream {
        private FailingFlushOutputStream() {
        }

        @Override
        public void write(int i) throws IOException {
        }

        @Override
        public void flush() throws IOException {
            throw new IOException("expected");
        }
    }

    private static final class FailingWriteOutputStream
    extends OutputStream {
        private FailingWriteOutputStream() {
        }

        @Override
        public void write(int i) throws IOException {
            throw new IOException("expected");
        }
    }
}

