/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots;

import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.snapshots.ConstructableSnapshotStore;
import io.camunda.zeebe.snapshots.PersistedSnapshot;
import io.camunda.zeebe.snapshots.TransientSnapshot;
import io.camunda.zeebe.util.FileUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.concurrent.Executor;

public final class SnapshotTransferUtil {
    public static final Map<String, String> SNAPSHOT_FILE_CONTENTS = Map.of("file1", "file1 contents", "file2", "file2 contents");

    public static ActorFuture<PersistedSnapshot> takePersistedSnapshot(ConstructableSnapshotStore senderSnapshotStore, Map<String, String> snapshotFileContents, ConcurrencyControl control) {
        TransientSnapshot transientSnapshot = (TransientSnapshot)senderSnapshotStore.newTransientSnapshot(1L, 0L, 1L, 0L, false).get();
        return transientSnapshot.take(p -> SnapshotTransferUtil.writeSnapshot(p, snapshotFileContents)).andThen(ignored -> transientSnapshot.persist(), (Executor)control);
    }

    public static void writeSnapshot(Path path, Map<String, String> snapshotFileContents) {
        try {
            FileUtil.ensureDirectoryExists((Path)path);
            for (Map.Entry<String, String> entry : snapshotFileContents.entrySet()) {
                Path fileName = path.resolve(entry.getKey());
                byte[] fileContent = entry.getValue().getBytes(StandardCharsets.UTF_8);
                Files.write(fileName, fileContent, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

