/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots;

import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.testing.ActorSchedulerRule;
import io.camunda.zeebe.snapshots.ReceivableSnapshotStore;
import io.camunda.zeebe.snapshots.ReceivedSnapshot;
import io.camunda.zeebe.snapshots.impl.FileBasedSnapshotStore;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class PersistedSnapshotStoreTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ActorSchedulerRule scheduler = new ActorSchedulerRule();
    private ReceivableSnapshotStore persistedSnapshotStore;

    @Before
    public void before() {
        boolean partitionId = true;
        File root = this.temporaryFolder.getRoot();
        FileBasedSnapshotStore snapshotStore = new FileBasedSnapshotStore(0, 1, root.toPath(), snapshotPath -> Map.of(), (MeterRegistry)new SimpleMeterRegistry());
        this.scheduler.submitActor((Actor)snapshotStore).join();
        this.persistedSnapshotStore = snapshotStore;
    }

    @Test
    public void shouldReturnZeroWhenNoSnapshotWasTaken() {
        long currentSnapshotIndex = this.persistedSnapshotStore.getCurrentSnapshotIndex();
        Assertions.assertThat((long)currentSnapshotIndex).isZero();
    }

    @Test
    public void shouldReturnEmptyWhenNoSnapshotWasTaken() {
        Optional optionalLatestSnapshot = this.persistedSnapshotStore.getLatestSnapshot();
        Assertions.assertThat((Optional)optionalLatestSnapshot).isEmpty();
    }

    @Test
    public void shouldReturnFalseOnNonExistingSnapshot() {
        boolean exists = this.persistedSnapshotStore.hasSnapshotId("notexisting");
        Assertions.assertThat((boolean)exists).isFalse();
    }

    @Test
    public void shouldTakeReceivedSnapshot() {
        long index = 1L;
        ReceivedSnapshot transientSnapshot = (ReceivedSnapshot)this.persistedSnapshotStore.newReceivedSnapshot("1-0-123-121").join();
        Assertions.assertThat((long)transientSnapshot.index()).isEqualTo(1L);
    }
}

