/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots.impl;

import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;

public final class SnapshotMetrics {
    private static final String NAMESPACE = "zeebe";
    private static final String PARTITION_LABEL_NAME = "partition";
    private static final Counter SNAPSHOT_COUNT = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).labelNames(new String[]{"partition"})).name("snapshot_count")).help("Total count of committed snapshots on disk")).register();
    private static final Gauge SNAPSHOT_SIZE = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).labelNames(new String[]{"partition"})).name("snapshot_size_bytes")).help("Estimated snapshot size on disk")).register();
    private static final Gauge SNAPSHOT_CHUNK_COUNT = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).labelNames(new String[]{"partition"})).name("snapshot_chunks_count")).help("Number of chunks in the last snapshot")).register();
    private static final Histogram SNAPSHOT_DURATION = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("zeebe")).labelNames(new String[]{"partition"})).name("snapshot_duration")).help("Approximate duration of snapshot operation")).register();
    private static final Histogram SNAPSHOT_PERSIST_DURATION = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("zeebe")).labelNames(new String[]{"partition"})).name("snapshot_persist_duration")).help("Approximate duration of snapshot persist operation")).register();
    private static final Histogram SNAPSHOT_FILE_SIZE = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("zeebe")).labelNames(new String[]{"partition"})).help("Approximate size of snapshot files")).name("snapshot_file_size_megabytes")).buckets(new double[]{0.01, 0.1, 0.5, 1.0, 5.0, 10.0, 25.0, 50.0, 100.0, 250.0, 500.0}).register();
    private final Histogram.Child snapshotPersistDuration;
    private final Histogram.Child snapshotFileSize;
    private final Histogram.Child snapshotDuration;
    private final Gauge.Child snapshotChunkCount;
    private final Gauge.Child snapshotSize;
    private final Counter.Child snapshotCount;

    public SnapshotMetrics(String partitionId) {
        this.snapshotDuration = (Histogram.Child)SNAPSHOT_DURATION.labels(new String[]{partitionId});
        this.snapshotPersistDuration = (Histogram.Child)SNAPSHOT_PERSIST_DURATION.labels(new String[]{partitionId});
        this.snapshotFileSize = (Histogram.Child)SNAPSHOT_FILE_SIZE.labels(new String[]{partitionId});
        this.snapshotChunkCount = (Gauge.Child)SNAPSHOT_CHUNK_COUNT.labels(new String[]{partitionId});
        this.snapshotSize = (Gauge.Child)SNAPSHOT_SIZE.labels(new String[]{partitionId});
        this.snapshotCount = (Counter.Child)SNAPSHOT_COUNT.labels(new String[]{partitionId});
    }

    void incrementSnapshotCount() {
        this.snapshotCount.inc();
    }

    void observeSnapshotSize(long sizeInBytes) {
        this.snapshotSize.set((double)sizeInBytes);
    }

    void observeSnapshotChunkCount(long count) {
        this.snapshotChunkCount.set((double)count);
    }

    void observeSnapshotFileSize(long sizeInBytes) {
        this.snapshotFileSize.observe((double)((float)sizeInBytes / 1000000.0f));
    }

    Histogram.Timer startTimer() {
        return this.snapshotDuration.startTimer();
    }

    Histogram.Timer startPersistTimer() {
        return this.snapshotPersistDuration.startTimer();
    }
}

