/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots.testing;

import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.snapshots.CRC32CChecksumProvider;
import io.camunda.zeebe.snapshots.PersistedSnapshot;
import io.camunda.zeebe.snapshots.PersistedSnapshotListener;
import io.camunda.zeebe.snapshots.ReceivableSnapshotStore;
import io.camunda.zeebe.snapshots.TransientSnapshot;
import io.camunda.zeebe.snapshots.impl.FileBasedReceivedSnapshot;
import io.camunda.zeebe.snapshots.impl.FileBasedSnapshotStoreImpl;
import io.camunda.zeebe.util.FileUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.zip.CRC32C;

public class TestFileBasedSnapshotStore
implements ReceivableSnapshotStore {
    private final FileBasedSnapshotStoreImpl snapshotStore;

    public TestFileBasedSnapshotStore(int nodeId, Path root, ConcurrencyControl concurrencyControl) {
        this.snapshotStore = new FileBasedSnapshotStoreImpl(nodeId, 1, root, (CRC32CChecksumProvider)new TestChecksumProvider(), concurrencyControl);
        this.snapshotStore.start();
    }

    public boolean hasSnapshotId(String id) {
        return this.snapshotStore.hasSnapshotId(id);
    }

    public Optional<PersistedSnapshot> getLatestSnapshot() {
        return this.snapshotStore.getLatestSnapshot();
    }

    public ActorFuture<Set<PersistedSnapshot>> getAvailableSnapshots() {
        return this.snapshotStore.getAvailableSnapshots();
    }

    public ActorFuture<Long> getCompactionBound() {
        return this.snapshotStore.getCompactionBound();
    }

    public ActorFuture<Void> purgePendingSnapshots() {
        return this.snapshotStore.purgePendingSnapshots();
    }

    public ActorFuture<Boolean> addSnapshotListener(PersistedSnapshotListener listener) {
        return this.snapshotStore.addSnapshotListener(listener);
    }

    public ActorFuture<Boolean> removeSnapshotListener(PersistedSnapshotListener listener) {
        return this.snapshotStore.removeSnapshotListener(listener);
    }

    public long getCurrentSnapshotIndex() {
        return this.snapshotStore.getCurrentSnapshotIndex();
    }

    public ActorFuture<Void> delete() {
        return this.snapshotStore.delete();
    }

    public Path getPath() {
        return this.snapshotStore.getPath();
    }

    public ActorFuture<FileBasedReceivedSnapshot> newReceivedSnapshot(String snapshotId) {
        return this.snapshotStore.newReceivedSnapshot(snapshotId);
    }

    public void close() {
        this.snapshotStore.close();
    }

    public void newSnapshot(long index, long term, int size, Random random) {
        Map<String, String> chunks = IntStream.range(0, size).boxed().map(i -> "chunk-" + i).collect(Collectors.toMap(k -> k, v -> String.valueOf(random.nextLong())));
        TransientSnapshot transientSnapshot = (TransientSnapshot)this.snapshotStore.newTransientSnapshot(index, term, index, index).get();
        transientSnapshot.take(p -> this.writeSnapshot((Path)p, chunks)).join();
        transientSnapshot.persist().join();
    }

    private boolean writeSnapshot(Path path, Map<String, String> chunks) {
        try {
            FileUtil.ensureDirectoryExists((Path)path);
            for (Map.Entry<String, String> entry : chunks.entrySet()) {
                Path fileName = path.resolve(entry.getKey());
                byte[] fileContent = entry.getValue().getBytes(StandardCharsets.UTF_8);
                Files.write(fileName, fileContent, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return true;
    }

    private static final class TestChecksumProvider
    implements CRC32CChecksumProvider {
        private TestChecksumProvider() {
        }

        public Map<String, Long> getSnapshotChecksums(Path snapshotPath) {
            HashMap<String, Long> checksums = new HashMap<String, Long>();
            try (DirectoryStream<Path> files = Files.newDirectoryStream(snapshotPath, p -> p.getFileName().toString().startsWith("chunk"));){
                files.forEach(file -> {
                    try {
                        CRC32C fileContentChecksum = new CRC32C();
                        fileContentChecksum.update(Files.readAllBytes(file));
                        checksums.put(file.getFileName().toString(), fileContentChecksum.getValue());
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return checksums;
        }
    }
}

