/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots.impl;

import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorControl;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.testing.ActorSchedulerRule;
import io.camunda.zeebe.snapshots.ImmutableChecksumsSFV;
import io.camunda.zeebe.snapshots.SnapshotReservation;
import io.camunda.zeebe.snapshots.impl.FileBasedSnapshot;
import io.camunda.zeebe.snapshots.impl.FileBasedSnapshotId;
import io.camunda.zeebe.snapshots.impl.SfvChecksumImpl;
import io.camunda.zeebe.snapshots.impl.SnapshotChecksum;
import io.camunda.zeebe.util.FileUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public final class FileBasedSnapshotTest {
    private static final Map<String, String> SNAPSHOT_FILE_CONTENTS = Map.of("file1", "file1 contents", "file2", "file2 contents");
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ActorSchedulerRule scheduler = new ActorSchedulerRule();
    private Path snapshotDir;
    private TestActor actor;

    @Before
    public void beforeEach() throws Exception {
        this.snapshotDir = this.temporaryFolder.newFolder(new String[]{"store", "snapshots"}).toPath();
        this.actor = new TestActor();
        this.scheduler.submitActor((Actor)this.actor);
    }

    @Test
    public void shouldDeleteSnapshot() throws IOException {
        Path snapshotPath = this.snapshotDir.resolve("snapshot");
        Path checksumPath = this.snapshotDir.resolve("checksum");
        FileBasedSnapshot snapshot = this.createSnapshot(snapshotPath, checksumPath);
        snapshot.delete();
        Assertions.assertThat((Path)snapshotPath).doesNotExist();
        Assertions.assertThat((Path)checksumPath).doesNotExist();
    }

    @Test
    public void shouldReserveSnapshot() throws IOException {
        Path snapshotPath = this.snapshotDir.resolve("snapshot");
        Path checksumPath = this.snapshotDir.resolve("checksum");
        FileBasedSnapshot snapshot = this.createSnapshot(snapshotPath, checksumPath);
        snapshot.reserve().join();
        Assertions.assertThat((boolean)snapshot.isReserved()).isTrue();
    }

    @Test
    public void shouldReleaseReservedSnapshot() throws IOException {
        Path snapshotPath = this.snapshotDir.resolve("snapshot");
        Path checksumPath = this.snapshotDir.resolve("checksum");
        FileBasedSnapshot snapshot = this.createSnapshot(snapshotPath, checksumPath);
        SnapshotReservation reservation = (SnapshotReservation)snapshot.reserve().join();
        reservation.release().join();
        Assertions.assertThat((boolean)snapshot.isReserved()).isFalse();
    }

    @Test
    public void shouldReleaseSnapshotOnlyAfterAllReservationsAreReleased() throws IOException {
        Path snapshotPath = this.snapshotDir.resolve("snapshot");
        Path checksumPath = this.snapshotDir.resolve("checksum");
        FileBasedSnapshot snapshot = this.createSnapshot(snapshotPath, checksumPath);
        SnapshotReservation firstReservation = (SnapshotReservation)snapshot.reserve().join();
        SnapshotReservation secondReservation = (SnapshotReservation)snapshot.reserve().join();
        firstReservation.release().join();
        Assertions.assertThat((boolean)snapshot.isReserved()).isTrue();
        secondReservation.release().join();
        Assertions.assertThat((boolean)snapshot.isReserved()).isFalse();
    }

    private FileBasedSnapshot createSnapshot(Path snapshotPath, Path checksumPath) throws IOException {
        FileBasedSnapshotId metadata = new FileBasedSnapshotId(1L, 1L, 1L, 1L, 0);
        FileUtil.ensureDirectoryExists((Path)snapshotPath);
        for (Map.Entry<String, String> entry : SNAPSHOT_FILE_CONTENTS.entrySet()) {
            Path fileName = snapshotPath.resolve(entry.getKey());
            byte[] fileContent = entry.getValue().getBytes(StandardCharsets.UTF_8);
            Files.write(fileName, fileContent, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        }
        SnapshotChecksum.persist((Path)checksumPath, (ImmutableChecksumsSFV)SnapshotChecksum.calculate((Path)snapshotPath));
        return new FileBasedSnapshot(snapshotPath, checksumPath, (ImmutableChecksumsSFV)new SfvChecksumImpl(), metadata, null, s -> {}, (ConcurrencyControl)this.actor.getActorControl());
    }

    static class TestActor
    extends Actor {
        TestActor() {
        }

        ActorControl getActorControl() {
            return this.actor;
        }
    }
}

