/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.qa.util.testcontainers;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.List;
import org.awaitility.Awaitility;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;
import org.testcontainers.utility.DockerImageName;

public final class GcsContainer
extends GenericContainer<GcsContainer> {
    private static final DockerImageName IMAGE = DockerImageName.parse((String)"fsouza/fake-gcs-server");
    private static final String IMAGE_TAG = "1";
    private static final int PORT = 8000;

    public GcsContainer() {
        super(IMAGE.withTag(IMAGE_TAG));
        this.setCommand(new String[]{"-scheme", "http", "-port", String.valueOf(8000)});
        this.setExposedPorts(List.of(Integer.valueOf(8000)));
        this.setWaitStrategy((WaitStrategy)new WaitAllStrategy().withStartupTimeout(Duration.ofMinutes(1L)).withStrategy((WaitStrategy)new HostPortWaitStrategy()).withStrategy((WaitStrategy)new URLUpdatingStrategy()));
    }

    public String externalEndpoint() {
        return "http://%s:%d".formatted(this.getHost(), this.getMappedPort(8000));
    }

    private static final class URLUpdatingStrategy
    implements WaitStrategy {
        private Duration startupTimeout = Duration.ofSeconds(30L);

        private URLUpdatingStrategy() {
        }

        public void waitUntilReady(WaitStrategyTarget waitStrategyTarget) {
            String endpoint = "http://" + waitStrategyTarget.getHost() + ":" + waitStrategyTarget.getMappedPort(8000);
            Awaitility.await((String)"until the external URL has been changed").atMost(this.startupTimeout).untilAsserted(() -> this.refreshExternalURL(endpoint));
        }

        public WaitStrategy withStartupTimeout(Duration startupTimeout) {
            this.startupTimeout = startupTimeout;
            return this;
        }

        private void refreshExternalURL(String endpoint) throws Exception {
            String modifyExternalUrlRequestUri = endpoint + "/_internal/config";
            String updateExternalUrlJson = "{\"externalUrl\": \"" + endpoint + "\"}";
            HttpRequest req = HttpRequest.newBuilder().uri(URI.create(modifyExternalUrlRequestUri)).header("Content-Type", "application/json").PUT(HttpRequest.BodyPublishers.ofString(updateExternalUrlJson)).build();
            HttpResponse<Void> response = HttpClient.newBuilder().build().send(req, HttpResponse.BodyHandlers.discarding());
            if (response.statusCode() != 200) {
                throw new RuntimeException("error updating fake-gcs-server with external url, response status code " + response.statusCode() + " != 200");
            }
        }
    }
}

