/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.qa.util.cluster;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.broker.shared.BrokerConfiguration;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.qa.util.actuator.HealthActuator;
import io.camunda.zeebe.qa.util.cluster.TestSpringApplication;
import io.camunda.zeebe.restore.RestoreApp;
import io.camunda.zeebe.shared.Profile;
import java.util.function.Consumer;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;

public final class TestRestoreApp
extends TestSpringApplication<TestRestoreApp> {
    private final BrokerConfiguration.BrokerProperties config;
    private Long backupId;

    public TestRestoreApp() {
        this(new BrokerConfiguration.BrokerProperties());
    }

    public TestRestoreApp(BrokerConfiguration.BrokerProperties config) {
        super(RestoreApp.class);
        this.config = config;
        ((TestRestoreApp)this.withBean("config", config, BrokerConfiguration.BrokerProperties.class)).withAdditionalProfile(Profile.RESTORE);
    }

    @Override
    public TestRestoreApp self() {
        return this;
    }

    @Override
    public MemberId nodeId() {
        return MemberId.from((String)String.valueOf(this.config.getCluster().getNodeId()));
    }

    @Override
    public HealthActuator healthActuator() {
        return new HealthActuator.NoopHealthActuator();
    }

    @Override
    public boolean isGateway() {
        return false;
    }

    @Override
    protected String[] commandLineArgs() {
        String[] stringArray;
        if (this.backupId == null) {
            stringArray = super.commandLineArgs();
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "--backupId=" + this.backupId;
        }
        return stringArray;
    }

    @Override
    protected SpringApplicationBuilder createSpringBuilder() {
        return super.createSpringBuilder().web(WebApplicationType.NONE);
    }

    public TestRestoreApp withBrokerConfig(Consumer<BrokerCfg> modifier) {
        modifier.accept((BrokerCfg)this.config);
        return this;
    }

    public TestRestoreApp withBackupId(long backupId) {
        this.backupId = backupId;
        return this;
    }
}

