/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.qa.util.actuator;

import feign.Feign;
import feign.Headers;
import feign.RequestLine;
import feign.Retryer;
import feign.Target;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import io.camunda.zeebe.qa.util.cluster.TestApplication;
import io.zeebe.containers.ZeebeNode;

public interface RebalanceActuator {
    public static RebalanceActuator of(ZeebeNode<?> node) {
        String endpoint = String.format("http://%s/actuator/rebalance", node.getExternalMonitoringAddress());
        return RebalanceActuator.of(endpoint);
    }

    public static RebalanceActuator of(TestApplication<?> node) {
        return RebalanceActuator.of(node.actuatorUri("rebalance").toString());
    }

    public static RebalanceActuator of(String endpoint) {
        Target.HardCodedTarget target = new Target.HardCodedTarget(RebalanceActuator.class, endpoint);
        return (RebalanceActuator)Feign.builder().encoder((Encoder)new JacksonEncoder()).decoder((Decoder)new JacksonDecoder()).retryer(Retryer.NEVER_RETRY).target((Target)target);
    }

    @RequestLine(value="POST")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void rebalance();
}

