/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.qa.util.actuator;

import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import feign.Feign;
import feign.RequestLine;
import feign.Retryer;
import feign.Target;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import io.camunda.zeebe.qa.util.actuator.HealthActuator;
import io.camunda.zeebe.qa.util.cluster.TestStandaloneBroker;
import io.zeebe.containers.ZeebeNode;
import java.util.List;

public interface BrokerHealthActuator
extends HealthActuator {
    public static BrokerHealthActuator of(ZeebeNode<?> node) {
        String address = node.getExternalMonitoringAddress();
        return BrokerHealthActuator.of("http://" + address);
    }

    public static BrokerHealthActuator of(TestStandaloneBroker node) {
        return BrokerHealthActuator.of(node.monitoringUri(new String[0]).toString());
    }

    public static BrokerHealthActuator of(String endpoint) {
        Target.HardCodedTarget target = new Target.HardCodedTarget(BrokerHealthActuator.class, endpoint);
        JacksonDecoder decoder = new JacksonDecoder(List.of(new Jdk8Module(), new JavaTimeModule()));
        return (BrokerHealthActuator)Feign.builder().encoder((Encoder)new JacksonEncoder()).decoder((Decoder)decoder).retryer(Retryer.NEVER_RETRY).target((Target)target);
    }

    @Override
    @RequestLine(value="GET /ready")
    public void ready();

    @Override
    @RequestLine(value="GET /startup")
    public void startup();

    @Override
    @RequestLine(value="GET /health")
    public void live();
}

