/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.qa.util.testcontainers;

import java.time.Duration;
import org.testcontainers.containers.GenericContainer;

public final class RemoteDebugger {
    public static final int DEFAULT_REMOTE_DEBUGGER_PORT = 5005;
    public static final Duration DEFAULT_START_TIMEOUT = Duration.ofMinutes(5L);

    private RemoteDebugger() {
    }

    public static void configureContainer(GenericContainer<?> container) {
        RemoteDebugger.configureContainer(container, 5005);
    }

    public static void configureContainer(GenericContainer<?> container, int port) {
        String javaOpts = container.getEnvMap().getOrDefault("JAVA_OPTS", "");
        container.addExposedPort(Integer.valueOf(port));
        container.getPortBindings().add(port + ":" + port);
        container.withEnv("JAVA_OPTS", "-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=0.0.0.0:" + port + " " + javaOpts);
        container.withStartupTimeout(DEFAULT_START_TIMEOUT);
    }
}

