/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.qa.util.testcontainers;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public final class MinioContainer
extends GenericContainer<MinioContainer> {
    private static final DockerImageName IMAGE = DockerImageName.parse((String)"minio/minio");
    private static final int PORT = 9000;
    private static final String DEFAULT_REGION = "us-east-1";
    private static final String DEFAULT_ACCESS_KEY = "accessKey";
    private static final String DEFAULT_SECRET_KEY = "secretKey";
    private String domain;

    public MinioContainer() {
        this("RELEASE.2022-09-17T00-09-45Z");
    }

    public MinioContainer(String version) {
        super(IMAGE.withTag(version));
        ((MinioContainer)((MinioContainer)((MinioContainer)((MinioContainer)((MinioContainer)this.withCommand("server /data")).withExposedPorts(new Integer[]{9000})).withEnv("MINIO_ACCESS_KEY", DEFAULT_ACCESS_KEY)).withEnv("MINIO_SECRET_KEY", DEFAULT_SECRET_KEY)).withEnv("MINIO_REGION", DEFAULT_REGION)).waitingFor(this.defaultWaitStrategy());
    }

    public WaitStrategy defaultWaitStrategy() {
        return new HttpWaitStrategy().forPath("/minio/health/ready").forPort(9000).withStartupTimeout(Duration.ofMinutes(1L));
    }

    public String externalEndpoint() {
        return "http://%s:%d".formatted(this.getHost(), this.getMappedPort(9000));
    }

    public String internalEndpoint() {
        return "http://%s:%d".formatted(this.internalHost(), 9000);
    }

    public String region() {
        return this.getEnvMap().getOrDefault("MINIO_REGION", DEFAULT_REGION);
    }

    public String accessKey() {
        return this.getEnvMap().getOrDefault("MINIO_ACCESS_KEY", DEFAULT_ACCESS_KEY);
    }

    public String secretKey() {
        return this.getEnvMap().getOrDefault("MINIO_SECRET_KEY", DEFAULT_SECRET_KEY);
    }

    public MinioContainer withDomain(String domain, String ... buckets) {
        this.domain = Objects.requireNonNull(domain, "must specify a domain");
        ((MinioContainer)this.withEnv("MINIO_DOMAIN", domain)).withNetworkAliases(new String[]{domain});
        Arrays.stream(buckets).map(name -> "%s.%s".formatted(name, domain)).forEach(xva$0 -> {
            MinioContainer cfr_ignored_0 = (MinioContainer)this.withNetworkAliases(new String[]{xva$0});
        });
        if (buckets.length == 0) {
            this.logger().warn("Configured minio with a domain but no buckets; make sure to use the container's IP address when accessing S3 via a client to enforce path-style access to your buckets");
        }
        return this;
    }

    private String internalHost() {
        if (this.domain != null) {
            return this.domain;
        }
        List networkAliases = this.getNetworkAliases();
        if (networkAliases.isEmpty()) {
            return this.getContainerInfo().getName();
        }
        return (String)networkAliases.get(networkAliases.size() - 1);
    }
}

