/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.qa.util.testcontainers;

import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;

public final class ContainerLogsDumper
implements AfterTestExecutionCallback {
    private static final Logger DEFAULT_LOGGER = LoggerFactory.getLogger(ContainerLogsDumper.class);
    private static final Pattern DOUBLE_NEWLINE = Pattern.compile("\n\n");
    private final Supplier<Map<?, ? extends Container<?>>> containersSupplier;
    private final Logger logger;

    public ContainerLogsDumper(Supplier<Map<?, ? extends Container<?>>> containersSupplier) {
        this(containersSupplier, DEFAULT_LOGGER);
    }

    public ContainerLogsDumper(Supplier<Map<?, ? extends Container<?>>> containers, Logger logger) {
        this.containersSupplier = containers;
        this.logger = logger;
    }

    public void afterTestExecution(ExtensionContext context) {
        boolean testFailed = context.getExecutionException().isPresent();
        if (!testFailed) {
            return;
        }
        Map<?, Container<?>> containers = this.containersSupplier.get();
        for (Map.Entry<?, Container<?>> container : containers.entrySet()) {
            Object id = container.getKey();
            try {
                this.dumpContainerLogs(id, container.getValue());
            }
            catch (Exception e) {
                this.logger.warn("Failed to extract logs from container {}", id, (Object)e);
            }
        }
    }

    private void dumpContainerLogs(Object id, Container<?> container) {
        if (!container.isRunning()) {
            this.logger.info("No logs to dump for stopped container {}", id);
            return;
        }
        if (this.logger.isErrorEnabled()) {
            String logs = container.getLogs().replaceAll(DOUBLE_NEWLINE.pattern(), "\n");
            this.logger.error("{}==============================================={}{} logs{}==============================================={}{}", new Object[]{System.lineSeparator(), System.lineSeparator(), id, System.lineSeparator(), System.lineSeparator(), logs});
        }
    }
}

