/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.qa.util.actuator;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import feign.Feign;
import feign.Headers;
import feign.RequestLine;
import feign.Retryer;
import feign.Target;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import io.zeebe.containers.ZeebeBrokerNode;
import java.util.Map;

public interface PartitionsActuator {
    public static PartitionsActuator of(ZeebeBrokerNode<?> node) {
        String endpoint = String.format("http://%s/actuator/partitions", node.getExternalMonitoringAddress());
        return PartitionsActuator.of(endpoint);
    }

    public static PartitionsActuator of(String endpoint) {
        Target.HardCodedTarget target = new Target.HardCodedTarget(PartitionsActuator.class, endpoint);
        return (PartitionsActuator)Feign.builder().encoder((Encoder)new JacksonEncoder()).decoder((Decoder)new JacksonDecoder()).retryer(Retryer.NEVER_RETRY).target((Target)target);
    }

    @RequestLine(value="GET /")
    @Headers(value={"Accept: application/json"})
    public Map<Integer, PartitionStatus> query();

    @RequestLine(value="POST /pauseExporting")
    @Headers(value={"Accept: application/json"})
    public Map<Integer, PartitionStatus> pauseExporting();

    @RequestLine(value="POST /resumeExporting")
    @Headers(value={"Accept: application/json"})
    public Map<Integer, PartitionStatus> resumeExporting();

    @RequestLine(value="POST /pauseProcessing")
    @Headers(value={"Accept: application/json"})
    public Map<Integer, PartitionStatus> pauseProcessing();

    @RequestLine(value="POST /resumeProcessing")
    @Headers(value={"Accept: application/json"})
    public Map<Integer, PartitionStatus> resumeProcessing();

    @RequestLine(value="POST /takeSnapshot")
    @Headers(value={"Accept: application/json"})
    public Map<Integer, PartitionStatus> takeSnapshot();

    @RequestLine(value="POST /prepareUpgrade")
    @Headers(value={"Accept: application/json"})
    public Map<Integer, PartitionStatus> prepareUpgrade();

    @JsonIgnoreProperties(ignoreUnknown=true)
    public record PartitionStatus(String role, String snapshotId, Long processedPosition, Long processedPositionInSnapshot, String streamProcessorPhase, Long exportedPosition, String exporterPhase) {
    }
}

