/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.qa.util.actuator;

import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import feign.Feign;
import feign.FeignException;
import feign.Headers;
import feign.Param;
import feign.Request;
import feign.RequestLine;
import feign.Response;
import feign.Retryer;
import feign.Target;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import io.camunda.zeebe.gateway.admin.backup.BackupStatus;
import io.zeebe.containers.ZeebeNode;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface BackupActuator {
    public static BackupActuator of(ZeebeNode<?> node) {
        String endpoint = String.format("http://%s/actuator/backups", node.getExternalMonitoringAddress());
        return BackupActuator.of(endpoint);
    }

    public static BackupActuator of(String endpoint) {
        Target.HardCodedTarget target = new Target.HardCodedTarget(BackupActuator.class, endpoint);
        JacksonDecoder decoder = new JacksonDecoder(List.of(new Jdk8Module()));
        return (BackupActuator)Feign.builder().encoder((Encoder)new JacksonEncoder()).decoder((Decoder)decoder).errorDecoder((ErrorDecoder)new ErrorHandler(decoder)).retryer(Retryer.NEVER_RETRY).target((Target)target);
    }

    @RequestLine(value="POST /{id}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public TakeBackupResponse take(@Param long var1);

    @RequestLine(value="GET /{id}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public BackupStatus status(@Param long var1);

    public static final class ErrorHandler
    implements ErrorDecoder {
        private final JacksonDecoder decoder;

        public ErrorHandler(JacksonDecoder decoder) {
            this.decoder = decoder;
        }

        public Exception decode(String methodKey, Response response) {
            if (response.status() == 500) {
                try {
                    ErrorResponse.Payload payload = (ErrorResponse.Payload)this.decoder.decode(response, ErrorResponse.Payload.class);
                    return new ErrorResponse(payload.failure(), response.request(), response.body().asInputStream().readAllBytes(), response.headers(), payload);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            return FeignException.errorStatus((String)methodKey, (Response)response);
        }
    }

    public static final class ErrorResponse
    extends FeignException.InternalServerError {
        private final Payload payload;

        private ErrorResponse(String message, Request request, byte[] body, Map<String, Collection<String>> headers, Payload payload) {
            super(message, request, body, headers);
            this.payload = payload;
        }

        public String failure() {
            return this.payload.failure();
        }

        public long id() {
            return this.payload.id();
        }

        record Payload(long id, String failure) {
        }
    }

    public record TakeBackupResponse(long id) {
    }
}

