/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.broker.protocol.brokerapi;

import io.atomix.cluster.AtomixCluster;
import io.atomix.cluster.Member;
import io.atomix.utils.net.Address;
import io.camunda.zeebe.protocol.impl.Loggers;
import io.camunda.zeebe.protocol.impl.encoding.BrokerInfo;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.scheduler.clock.ControlledActorClock;
import io.camunda.zeebe.test.broker.protocol.MsgPackHelper;
import io.camunda.zeebe.test.broker.protocol.brokerapi.ExecuteCommandRequest;
import io.camunda.zeebe.test.broker.protocol.brokerapi.ExecuteCommandResponseTypeBuilder;
import io.camunda.zeebe.test.broker.protocol.brokerapi.StubRequestHandler;
import io.camunda.zeebe.test.util.socket.SocketUtil;
import io.camunda.zeebe.transport.RequestHandler;
import io.camunda.zeebe.transport.RequestType;
import io.camunda.zeebe.transport.ServerTransport;
import io.camunda.zeebe.transport.TransportFactory;
import io.camunda.zeebe.util.VersionUtil;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.agrona.concurrent.IdGenerator;
import org.agrona.concurrent.SnowflakeIdGenerator;

public final class StubBroker
implements AutoCloseable {
    private static final String CLUSTER_ID = "cluster";
    private final int nodeId;
    private final int partitionId;
    private final InetSocketAddress socketAddress;
    private final BrokerInfo brokerInfo;
    private ActorScheduler scheduler;
    private MsgPackHelper msgPackHelper;
    private final ControlledActorClock clock = new ControlledActorClock();
    private StubRequestHandler channelHandler;
    private AtomixCluster cluster;
    private int currentStubPort;
    private String currentStubHost;
    private ServerTransport serverTransport;
    private final MeterRegistry meterRegistry = new SimpleMeterRegistry();

    public StubBroker() {
        this(0);
    }

    public StubBroker(int nodeId) {
        this(nodeId, 1);
    }

    public StubBroker(int nodeId, int partitionId) {
        this.nodeId = nodeId;
        this.partitionId = partitionId;
        this.socketAddress = SocketUtil.getNextAddress();
        this.brokerInfo = new BrokerInfo().setCommandApiAddress(Address.from((String)"localhost", (int)this.socketAddress.getPort()).toString()).setClusterSize(1).setReplicationFactor(1).setPartitionsCount(1).setNodeId(nodeId).setPartitionHealthy(Integer.valueOf(1)).setLeaderForPartition(partitionId, 1L);
        this.brokerInfo.setVersion(VersionUtil.getVersion());
    }

    public StubBroker start() {
        this.msgPackHelper = new MsgPackHelper();
        int numThreads = 2;
        this.scheduler = ActorScheduler.newActorScheduler().setCpuBoundActorThreadCount(2).setActorClock((ActorClock)this.clock).build();
        this.scheduler.start();
        this.currentStubHost = this.socketAddress.getHostName();
        this.currentStubPort = this.socketAddress.getPort();
        this.cluster = AtomixCluster.builder((MeterRegistry)this.meterRegistry).withPort(this.currentStubPort).withMemberId("0").withClusterId(CLUSTER_ID).build();
        this.cluster.start().join();
        TransportFactory transportFactory = new TransportFactory((ActorSchedulingService)this.scheduler);
        SnowflakeIdGenerator requestIdGenerator = new SnowflakeIdGenerator((long)this.nodeId);
        this.serverTransport = transportFactory.createServerTransport(this.cluster.getMessagingService(), (IdGenerator)requestIdGenerator);
        this.channelHandler = new StubRequestHandler(this.msgPackHelper);
        this.serverTransport.subscribe(this.partitionId, RequestType.COMMAND, (RequestHandler)this.channelHandler);
        this.writeBrokerInfoProperties();
        return this;
    }

    public Member member() {
        return this.cluster.getMembershipService().getLocalMember();
    }

    public StubBroker updateInfo(Consumer<BrokerInfo> consumer) {
        consumer.accept(this.brokerInfo);
        this.writeBrokerInfoProperties();
        return this;
    }

    private void writeBrokerInfoProperties() {
        this.brokerInfo.writeIntoProperties(this.cluster.getMembershipService().getLocalMember().properties());
    }

    @Override
    public void close() {
        try {
            this.serverTransport.close();
        }
        catch (Exception e) {
            Loggers.PROTOCOL_LOGGER.error("Error on closing server transport.", (Throwable)e);
        }
        if (this.scheduler != null) {
            this.scheduler.stop();
        }
        this.cluster.stop().join();
    }

    public int getCurrentStubPort() {
        return this.currentStubPort;
    }

    public String getCurrentStubHost() {
        return this.currentStubHost;
    }

    private ExecuteCommandResponseTypeBuilder onExecuteCommandRequest(Predicate<ExecuteCommandRequest> activationFunction) {
        return new ExecuteCommandResponseTypeBuilder(this.channelHandler::addExecuteCommandRequestStub, activationFunction, this.msgPackHelper);
    }

    public ExecuteCommandResponseTypeBuilder onExecuteCommandRequest(ValueType eventType, Intent intent) {
        return this.onExecuteCommandRequest(ecr -> ecr.valueType() == eventType && ecr.intent() == intent);
    }

    public List<ExecuteCommandRequest> getReceivedCommandRequests() {
        return this.channelHandler.getReceivedCommandRequests();
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public String clusterId() {
        return CLUSTER_ID;
    }
}

